<?php

require_once("FeedWriter.php");

// create a RSS2 feed
$feed = new FeedWriter(RSS2);
$feed
  ->setCDATAEncoding('title')
  ->setCDATAEncoding('copyright')
  ->setTitle('Crowdedplace.com')
  ->setLink('http://www.crowdedplace.com')
  ->setNamespace('http://www.w3.org/2005/Atom', 'atom')
  ->setDescription('Currently just some opensource stuff...')
  ->setImage('Crowdedplace.com', 'http://www.crowdedplace.com', 'http://www.crowdedplace.com/rssfeeds-php/gnu-head-sm.jpg')
  ->setChannelElement('atom:link', '', array("href" => "http://www.crowdedplace.com/rssfeeds-php/example-rss2.php", "rel" => "self", "type" => "application/rss+xml"))
  ->setChannelElements(array(
    'language'  => 'en-en',
    'copyright' => 'Copyright (c) '.date("Y").' Guenther Mair - all rights reserved.',
    'pubDate' => date(DATE_RSS, time()),
    'lastBuildDate' => date(DATE_RSS, time()),
    'generator' => 'little dwarfs working in the background',
    'webMaster' => 'info@crowdedplace.com (info@crowdedplace.com)',
    'ttl' => '20',
  ));

// create sample feed item n. 1
$item = $feed->createNewItem();
$item
  ->setTitle('Nagios check_hr')
  ->setLink('http://www.crowdedplace.com/host-resource-mib-queries-cpu-processes-storage-v3-7/')
  ->addElement('guid', 'http://www.crowdedplace.com/host-resource-mib-queries-cpu-processes-storage-v3-7/', array("isPermaLink" => "true"))
  ->setDescription(
    '<img src="http://www.crowdedplace.com/rssfeeds-php/gnu-head-sm.jpg" border="0" align="left" alt="" title="" />'.
    'Nagios plugin for Host-Resource-MIB queries: cpu, processes, storage (v3.7)'
  );
// add item to feed
$feed->addItem($item);

// create sample feed item n. 2
$item = $feed->createNewItem();
$item
  ->setTitle('Nagios check_hp')
  ->setLink('http://www.crowdedplace.com/compaq-hp-proliant-server-and-blade-checks-v25/')
  ->addElement('guid', 'http://www.crowdedplace.com/compaq-hp-proliant-server-and-blade-checks-v25/', array("isPermaLink" => "true"))
  ->setDescription(
    '<img src="http://www.crowdedplace.com/rssfeeds-php/gnu-head-sm.jpg" border="0" align="left" alt="" title="" />'.
    'Nagios plugin for Compaq-HP Proliant Server and Blade Checks (v2.5)'
  );
// add item to feed
$feed->addItem($item);


// PRINT RSS FEED
$feed->generateFeed();
