<?php

class TP_yyToken implements ArrayAccess
{
    public $string = '';

    public $metadata = array();

    public function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    public function __toString()
    {
        return $this->string;
    }

    public function offsetExists($offset)
    {
        return isset($this->metadata[ $offset ]);
    }

    public function offsetGet($offset)
    {
        return $this->metadata[ $offset ];
    }

    public function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[ 0 ])) {
                $x = ($value instanceof TP_yyToken) ? $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);

                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[ $offset ] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[ $offset ] = $value;
        }
    }

    public function offsetUnset($offset)
    {
        unset($this->metadata[ $offset ]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
}

;

#line 11 "../smarty/lexer/smarty_internal_templateparser.y"

/**
 * Smarty Template Parser Class
 *
 * This is the template parser.
 * It is generated from the smarty_internal_templateparser.y file
 *
 * @author Uwe Tews <uwe.tews@googlemail.com>
 */
class Smarty_Internal_Templateparser
{
    #line 23 "../smarty/lexer/smarty_internal_templateparser.y"

    const Err1 = "Security error: Call to private object member not allowed";

    const Err2 = "Security error: Call to dynamic object member not allowed";

    const Err3 = "PHP in template not allowed. Use SmartyBC to enable it";

    /**
     * result status
     *
     * @var bool
     */
    public $successful = true;

    /**
     * return value
     *
     * @var mixed
     */
    public $retvalue = 0;

    /**
     * @var
     */
    public $yymajor;

    /**
     * last index of array variable
     *
     * @var mixed
     */
    public $last_index;

    /**
     * last variable name
     *
     * @var string
     */
    public $last_variable;

    /**
     * root parse tree buffer
     *
     * @var Smarty_Internal_ParseTree
     */
    public $root_buffer;

    /**
     * current parse tree object
     *
     * @var Smarty_Internal_ParseTree
     */
    public $current_buffer;

    /**
     * lexer object
     *
     * @var Smarty_Internal_Templatelexer
     */
    public $lex;

    /**
     * internal error flag
     *
     * @var bool
     */
    private $internalError = false;

    /**
     * {strip} status
     *
     * @var bool
     */
    public $strip = false;

    /**
     * compiler object
     *
     * @var Smarty_Internal_TemplateCompilerBase
     */
    public $compiler = null;

    /**
     * smarty object
     *
     * @var Smarty
     */
    public $smarty = null;

    /**
     * template object
     *
     * @var Smarty_Internal_Template
     */
    public $template = null;

    /**
     * block nesting level
     *
     * @var int
     */
    public $block_nesting_level = 0;

    /**
     * security object
     *
     * @var Smarty_Security
     */
    public $security = null;

    /**
     * template prefix array
     *
     * @var \Smarty_Internal_ParseTree[]
     */
    public $template_prefix = array();

    /**
     * security object
     *
     * @var \Smarty_Internal_ParseTree[]
     */
    public $template_postfix = array();

    /**
     * constructor
     *
     * @param Smarty_Internal_Templatelexer        $lex
     * @param Smarty_Internal_TemplateCompilerBase $compiler
     */
    function __construct(Smarty_Internal_Templatelexer $lex, Smarty_Internal_TemplateCompilerBase $compiler)
    {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->template = $this->compiler->template;
        $this->smarty = $this->template->smarty;
        $this->security = isset($this->smarty->security_policy) ? $this->smarty->security_policy : false;
        $this->current_buffer = $this->root_buffer = new Smarty_Internal_ParseTree_Template();
    }

    /**
     * insert PHP code in current buffer
     *
     * @param string $code
     */
    public function insertPhpCode($code)
    {
        $this->current_buffer->append_subtree($this, new Smarty_Internal_ParseTree_Tag($this, $code));
    }

    /**
     *  merge PHP code with prefix code and return parse tree tag object
     *
     * @param string $code
     *
     * @return Smarty_Internal_ParseTree_Tag
     */
    public function mergePrefixCode($code)
    {
        $tmp = '';
        foreach ($this->compiler->prefix_code as $preCode) {
            $tmp .= $preCode;
        }
        $this->compiler->prefix_code = array();
        $tmp .= $code;
        return new Smarty_Internal_ParseTree_Tag($this, $this->compiler->processNocacheCode($tmp, true));
    }

    const TP_VERT = 1;

    const TP_COLON = 2;

    const TP_PHP = 3;

    const TP_NOCACHE = 4;

    const TP_TEXT = 5;

    const TP_STRIPON = 6;

    const TP_STRIPOFF = 7;

    const TP_LITERALSTART = 8;

    const TP_LITERALEND = 9;

    const TP_LITERAL = 10;

    const TP_RDEL = 11;

    const TP_SIMPELOUTPUT = 12;

    const TP_LDEL = 13;

    const TP_DOLLARID = 14;

    const TP_EQUAL = 15;

    const TP_SIMPLETAG = 16;

    const TP_ID = 17;

    const TP_PTR = 18;

    const TP_LDELMAKENOCACHE = 19;

    const TP_LDELIF = 20;

    const TP_LDELFOR = 21;

    const TP_SEMICOLON = 22;

    const TP_INCDEC = 23;

    const TP_TO = 24;

    const TP_STEP = 25;

    const TP_LDELFOREACH = 26;

    const TP_SPACE = 27;

    const TP_AS = 28;

    const TP_APTR = 29;

    const TP_LDELSETFILTER = 30;

    const TP_SMARTYBLOCKCHILDPARENT = 31;

    const TP_CLOSETAG = 32;

    const TP_LDELSLASH = 33;

    const TP_ATTR = 34;

    const TP_INTEGER = 35;

    const TP_COMMA = 36;

    const TP_OPENP = 37;

    const TP_CLOSEP = 38;

    const TP_MATH = 39;

    const TP_UNIMATH = 40;

    const TP_ISIN = 41;

    const TP_QMARK = 42;

    const TP_NOT = 43;

    const TP_TYPECAST = 44;

    const TP_HEX = 45;

    const TP_DOT = 46;

    const TP_INSTANCEOF = 47;

    const TP_SINGLEQUOTESTRING = 48;

    const TP_DOUBLECOLON = 49;

    const TP_NAMESPACE = 50;

    const TP_AT = 51;

    const TP_HATCH = 52;

    const TP_OPENB = 53;

    const TP_CLOSEB = 54;

    const TP_DOLLAR = 55;

    const TP_LOGOP = 56;

    const TP_SLOGOP = 57;

    const TP_TLOGOP = 58;

    const TP_SINGLECOND = 59;

    const TP_QUOTE = 60;

    const TP_BACKTICK = 61;

    const YY_NO_ACTION = 534;

    const YY_ACCEPT_ACTION = 533;

    const YY_ERROR_ACTION = 532;

    const YY_SZ_ACTTAB = 2017;

    static public $yy_action = array(269, 8, 133, 295, 335, 80, 282, 219, 7, 84, 128, 178, 255, 276, 113, 102, 13, 83,
                                     227, 286, 305, 220, 36, 223, 283, 21, 32, 297, 41, 14, 90, 40, 44, 260, 213, 231,
                                     250, 235, 210, 128, 81, 1, 298, 296, 102, 269, 8, 132, 79, 335, 196, 184, 219, 7,
                                     84, 26, 297, 461, 101, 113, 39, 24, 278, 227, 461, 305, 220, 171, 206, 222, 21,
                                     230, 201, 41, 104, 192, 40, 44, 260, 213, 18, 236, 241, 210, 251, 81, 1, 316, 296,
                                     114, 269, 8, 135, 79, 335, 205, 302, 219, 7, 84, 116, 107, 477, 477, 113, 33, 197,
                                     477, 227, 266, 305, 220, 326, 223, 31, 21, 29, 215, 41, 311, 78, 40, 44, 260, 213,
                                     296, 250, 256, 210, 190, 81, 1, 3, 296, 307, 269, 8, 134, 79, 335, 205, 302, 219,
                                     7, 84, 232, 18, 296, 294, 113, 334, 85, 323, 227, 136, 305, 220, 328, 223, 29, 21,
                                     183, 101, 41, 234, 78, 40, 44, 260, 213, 137, 250, 314, 210, 139, 81, 1, 10, 296,
                                     101, 269, 8, 135, 79, 335, 195, 154, 219, 7, 84, 322, 232, 81, 114, 113, 296, 329,
                                     94, 227, 315, 305, 220, 326, 212, 120, 21, 168, 215, 41, 281, 114, 40, 44, 260,
                                     213, 296, 250, 222, 210, 265, 81, 1, 104, 296, 211, 269, 8, 135, 79, 335, 193, 302,
                                     219, 7, 84, 242, 239, 249, 217, 113, 11, 215, 289, 227, 136, 305, 220, 228, 223,
                                     222, 21, 238, 149, 41, 104, 78, 40, 44, 260, 213, 461, 250, 329, 210, 6, 81, 1,
                                     461, 296, 2, 269, 8, 136, 79, 335, 205, 158, 219, 7, 84, 190, 211, 81, 101, 113,
                                     296, 329, 93, 227, 12, 305, 220, 18, 223, 244, 34, 268, 448, 41, 281, 449, 40, 44,
                                     260, 213, 191, 250, 36, 210, 448, 81, 1, 449, 296, 14, 269, 8, 135, 79, 335, 205,
                                     15, 219, 7, 84, 186, 293, 152, 14, 113, 16, 214, 5, 227, 165, 305, 220, 329, 194,
                                     20, 21, 140, 101, 41, 115, 448, 40, 44, 260, 213, 281, 250, 303, 210, 264, 81, 1,
                                     448, 296, 169, 269, 8, 131, 79, 335, 205, 176, 219, 7, 84, 137, 28, 296, 310, 113,
                                     185, 293, 10, 227, 275, 305, 220, 296, 223, 175, 4, 281, 143, 41, 144, 192, 40, 44,
                                     260, 213, 35, 250, 329, 210, 329, 81, 1, 270, 296, 308, 269, 8, 135, 79, 335, 198,
                                     121, 219, 7, 84, 190, 292, 17, 232, 113, 166, 284, 281, 227, 141, 305, 220, 211,
                                     223, 319, 21, 299, 211, 41, 329, 211, 40, 44, 260, 213, 258, 250, 363, 210, 221,
                                     81, 1, 281, 296, 6, 269, 8, 136, 79, 335, 205, 177, 219, 7, 84, 167, 211, 159, 22,
                                     113, 104, 211, 156, 227, 300, 305, 220, 329, 223, 274, 34, 359, 329, 41, 172, 192,
                                     40, 44, 260, 213, 95, 250, 318, 210, 329, 81, 273, 36, 296, 257, 292, 17, 181, 79,
                                     14, 284, 309, 277, 254, 262, 263, 259, 178, 211, 25, 36, 269, 8, 187, 331, 335,
                                     261, 14, 219, 7, 84, 192, 303, 211, 38, 113, 237, 321, 180, 227, 267, 305, 220,
                                     153, 121, 312, 179, 192, 272, 108, 215, 209, 211, 118, 69, 112, 43, 42, 37, 248,
                                     102, 86, 189, 252, 279, 182, 293, 150, 271, 204, 317, 176, 297, 288, 287, 285, 280,
                                     329, 281, 312, 174, 87, 202, 330, 215, 209, 170, 118, 69, 112, 43, 42, 37, 138,
                                     102, 192, 402, 252, 279, 38, 216, 88, 271, 204, 317, 211, 297, 288, 287, 285, 280,
                                     310, 402, 105, 253, 404, 164, 332, 312, 402, 211, 89, 448, 215, 209, 305, 129, 61,
                                     106, 163, 238, 404, 142, 102, 448, 305, 252, 279, 404, 305, 305, 271, 204, 317,
                                     305, 297, 312, 155, 305, 305, 305, 215, 209, 211, 129, 73, 112, 211, 43, 42, 37,
                                     102, 305, 404, 252, 279, 305, 292, 17, 271, 204, 317, 284, 297, 305, 288, 287, 285,
                                     280, 404, 203, 305, 477, 477, 312, 305, 404, 477, 305, 215, 209, 305, 129, 73, 112,
                                     43, 42, 37, 305, 102, 305, 305, 252, 279, 305, 305, 224, 271, 204, 317, 324, 297,
                                     288, 287, 285, 280, 305, 305, 208, 312, 305, 477, 305, 305, 215, 209, 211, 129, 50,
                                     106, 305, 117, 305, 305, 102, 148, 401, 252, 279, 92, 325, 448, 271, 204, 317, 329,
                                     297, 269, 9, 327, 218, 335, 401, 448, 219, 7, 84, 305, 320, 401, 305, 113, 325,
                                     192, 305, 227, 305, 305, 220, 269, 9, 327, 305, 335, 305, 305, 219, 7, 84, 305, 43,
                                     42, 37, 113, 305, 305, 305, 227, 305, 305, 220, 305, 305, 305, 305, 291, 27, 288,
                                     287, 285, 280, 305, 305, 305, 312, 305, 305, 305, 305, 215, 209, 305, 129, 73, 112,
                                     211, 305, 290, 27, 102, 305, 305, 252, 279, 305, 369, 305, 271, 204, 317, 305, 297,
                                     225, 305, 312, 305, 211, 305, 207, 215, 209, 36, 129, 54, 112, 305, 188, 305, 14,
                                     102, 145, 448, 252, 279, 91, 305, 305, 271, 204, 317, 329, 297, 312, 448, 292, 17,
                                     305, 215, 209, 284, 129, 65, 112, 305, 43, 42, 37, 102, 192, 305, 252, 279, 305,
                                     305, 305, 271, 204, 317, 305, 297, 312, 288, 287, 285, 280, 215, 209, 305, 99, 67,
                                     112, 305, 305, 229, 305, 102, 305, 305, 252, 279, 305, 305, 305, 271, 204, 317,
                                     312, 297, 211, 305, 305, 215, 209, 305, 129, 45, 112, 305, 246, 305, 305, 102, 162,
                                     305, 252, 279, 184, 305, 305, 271, 204, 317, 329, 297, 312, 39, 24, 278, 305, 215,
                                     209, 305, 129, 56, 112, 305, 43, 42, 37, 102, 192, 305, 252, 279, 305, 305, 305,
                                     271, 204, 317, 305, 297, 312, 288, 287, 285, 280, 215, 209, 305, 96, 55, 112, 305,
                                     305, 305, 305, 102, 305, 305, 252, 279, 305, 305, 305, 271, 204, 317, 312, 297,
                                     211, 305, 305, 215, 97, 305, 82, 47, 103, 305, 247, 305, 305, 102, 151, 305, 252,
                                     279, 184, 305, 305, 271, 204, 317, 329, 297, 312, 39, 24, 278, 305, 215, 209, 305,
                                     129, 71, 112, 305, 43, 42, 37, 102, 192, 305, 252, 279, 305, 305, 305, 271, 204,
                                     317, 305, 297, 312, 288, 287, 285, 280, 215, 209, 305, 129, 59, 112, 305, 305, 305,
                                     305, 102, 305, 305, 252, 279, 305, 305, 305, 271, 204, 317, 312, 297, 211, 305,
                                     305, 215, 209, 305, 129, 58, 112, 305, 305, 305, 305, 102, 160, 305, 252, 279, 184,
                                     305, 305, 271, 204, 317, 329, 297, 312, 39, 24, 278, 305, 215, 209, 305, 129, 53,
                                     112, 226, 43, 42, 37, 102, 192, 305, 252, 279, 305, 305, 305, 271, 204, 317, 305,
                                     297, 312, 288, 287, 285, 280, 215, 209, 305, 129, 60, 112, 305, 305, 305, 305, 102,
                                     305, 305, 252, 279, 305, 305, 305, 271, 204, 317, 312, 297, 211, 305, 305, 215,
                                     209, 305, 100, 64, 112, 305, 305, 305, 305, 102, 146, 305, 252, 279, 184, 305, 305,
                                     271, 204, 317, 329, 297, 312, 39, 24, 278, 305, 215, 209, 305, 129, 61, 112, 245,
                                     43, 42, 37, 102, 192, 305, 252, 279, 305, 305, 305, 271, 204, 317, 305, 297, 312,
                                     288, 287, 285, 280, 215, 200, 305, 129, 63, 112, 305, 305, 305, 305, 102, 305, 305,
                                     252, 279, 305, 305, 305, 271, 204, 317, 312, 297, 211, 305, 305, 215, 209, 305,
                                     111, 51, 112, 305, 305, 305, 305, 102, 147, 305, 252, 279, 184, 305, 305, 271, 204,
                                     317, 329, 297, 312, 39, 24, 278, 305, 215, 209, 305, 129, 49, 112, 305, 43, 42, 37,
                                     102, 192, 305, 252, 279, 305, 305, 305, 271, 204, 317, 305, 297, 312, 288, 287,
                                     285, 280, 215, 209, 305, 129, 75, 112, 305, 305, 305, 305, 102, 305, 305, 252, 279,
                                     305, 305, 305, 271, 204, 317, 312, 297, 305, 305, 305, 215, 209, 305, 129, 76, 112,
                                     305, 305, 305, 305, 102, 161, 305, 252, 279, 184, 305, 305, 271, 204, 317, 329,
                                     297, 312, 39, 24, 278, 305, 215, 98, 305, 82, 46, 103, 305, 305, 305, 305, 102,
                                     192, 305, 252, 279, 305, 305, 305, 271, 204, 317, 305, 297, 312, 305, 305, 305,
                                     305, 215, 209, 305, 129, 70, 112, 305, 305, 305, 305, 102, 305, 305, 252, 279, 305,
                                     305, 305, 271, 204, 317, 312, 297, 305, 305, 305, 215, 209, 305, 129, 57, 112, 305,
                                     305, 305, 305, 102, 305, 305, 252, 279, 305, 305, 305, 271, 204, 317, 305, 297,
                                     312, 305, 305, 305, 305, 215, 199, 305, 109, 62, 112, 305, 305, 305, 305, 102, 305,
                                     305, 252, 279, 305, 305, 305, 271, 204, 317, 305, 297, 312, 305, 305, 305, 305,
                                     215, 209, 305, 129, 72, 112, 305, 305, 305, 305, 102, 305, 305, 252, 279, 305, 305,
                                     305, 271, 204, 317, 312, 297, 305, 305, 305, 215, 209, 305, 129, 77, 112, 305, 305,
                                     305, 305, 102, 305, 305, 252, 279, 305, 305, 305, 271, 204, 317, 305, 297, 312,
                                     305, 305, 305, 305, 215, 209, 305, 129, 68, 112, 305, 305, 305, 305, 102, 305, 305,
                                     252, 279, 305, 305, 305, 271, 204, 317, 305, 297, 312, 305, 305, 305, 305, 215,
                                     209, 305, 129, 74, 112, 305, 305, 305, 305, 102, 305, 305, 252, 279, 305, 305, 305,
                                     271, 204, 317, 312, 297, 305, 305, 305, 215, 209, 305, 129, 48, 112, 305, 305, 305,
                                     305, 102, 305, 305, 252, 279, 414, 414, 305, 271, 204, 317, 305, 297, 312, 305,
                                     305, 305, 305, 215, 209, 305, 129, 66, 112, 305, 305, 305, 305, 102, 305, 305, 252,
                                     279, 211, 305, 305, 271, 204, 317, 305, 297, 448, 305, 414, 414, 414, 533, 52, 243,
                                     239, 249, 217, 305, 448, 215, 305, 305, 30, 305, 36, 414, 414, 414, 414, 305, 233,
                                     14, 305, 305, 305, 305, 43, 42, 37, 305, 477, 477, 312, 23, 305, 477, 461, 215,
                                     209, 211, 127, 305, 112, 288, 287, 285, 280, 102, 305, 301, 357, 313, 305, 292, 17,
                                     271, 204, 317, 284, 297, 305, 305, 302, 305, 461, 36, 36, 461, 36, 477, 157, 461,
                                     14, 14, 305, 14, 305, 43, 42, 37, 305, 305, 305, 312, 305, 211, 78, 305, 215, 209,
                                     305, 130, 305, 112, 288, 287, 285, 280, 102, 305, 305, 305, 240, 305, 292, 17, 271,
                                     204, 317, 284, 297, 36, 305, 305, 305, 305, 305, 305, 14, 36, 305, 173, 312, 43,
                                     42, 37, 14, 215, 209, 305, 122, 305, 112, 305, 305, 305, 305, 102, 304, 305, 288,
                                     287, 285, 280, 305, 271, 204, 317, 305, 297, 302, 305, 312, 305, 36, 305, 305, 215,
                                     209, 305, 123, 14, 112, 312, 305, 305, 305, 102, 215, 209, 305, 124, 305, 112, 78,
                                     271, 204, 317, 102, 297, 305, 305, 305, 305, 305, 305, 271, 204, 317, 312, 297,
                                     305, 305, 305, 215, 209, 305, 119, 305, 112, 305, 305, 305, 305, 102, 305, 305,
                                     233, 305, 305, 305, 305, 271, 204, 317, 305, 297, 477, 477, 312, 32, 305, 477, 461,
                                     215, 209, 305, 126, 305, 112, 305, 305, 305, 305, 102, 305, 305, 233, 305, 305,
                                     305, 305, 271, 204, 317, 305, 297, 477, 477, 305, 305, 461, 477, 461, 461, 312,
                                     477, 19, 461, 211, 215, 209, 305, 125, 305, 112, 305, 477, 477, 305, 102, 305, 477,
                                     461, 305, 305, 305, 305, 271, 204, 317, 461, 297, 305, 461, 305, 477, 305, 461,
                                     333, 305, 211, 305, 305, 305, 305, 305, 43, 42, 37, 305, 461, 305, 305, 461, 305,
                                     477, 305, 461, 305, 305, 233, 110, 305, 288, 287, 285, 280, 305, 306, 305, 477,
                                     477, 305, 305, 305, 477, 461, 305, 43, 42, 37, 477, 477, 305, 305, 305, 477, 461,
                                     305, 305, 305, 305, 305, 305, 305, 288, 287, 285, 280, 305, 305, 305, 305, 305,
                                     461, 305, 305, 461, 408, 477, 305, 461, 305, 305, 305, 461, 305, 305, 461, 408,
                                     477, 408, 461, 305, 408, 305, 305, 305, 305, 305, 305, 408, 305, 408, 305, 408,
                                     305, 305, 305, 305, 305, 305, 305, 232,);

    static public $yy_lookahead = array(12, 13, 14, 17, 16, 17, 72, 19, 20, 21, 76, 8, 9, 10, 26, 81, 22, 17, 30, 31,
                                        32, 33, 27, 35, 90, 37, 15, 93, 40, 34, 36, 43, 44, 45, 46, 72, 48, 51, 50, 76,
                                        52, 53, 98, 55, 81, 12, 13, 14, 60, 16, 17, 77, 19, 20, 21, 15, 93, 46, 18, 26,
                                        86, 87, 88, 30, 53, 32, 33, 94, 35, 76, 37, 78, 79, 40, 81, 101, 43, 44, 45, 46,
                                        36, 48, 38, 50, 14, 52, 53, 54, 55, 49, 12, 13, 14, 60, 16, 17, 23, 19, 20, 21,
                                        17, 81, 12, 13, 26, 13, 14, 17, 30, 17, 32, 33, 66, 35, 15, 37, 15, 71, 40, 99,
                                        47, 43, 44, 45, 46, 55, 48, 35, 50, 101, 52, 53, 36, 55, 61, 12, 13, 14, 60, 16,
                                        17, 23, 19, 20, 21, 46, 36, 55, 38, 26, 54, 105, 106, 30, 14, 32, 33, 17, 35,
                                        15, 37, 14, 18, 40, 17, 47, 43, 44, 45, 46, 46, 48, 54, 50, 14, 52, 53, 53, 55,
                                        18, 12, 13, 14, 60, 16, 17, 73, 19, 20, 21, 50, 46, 52, 49, 26, 55, 83, 37, 30,
                                        54, 32, 33, 66, 35, 17, 37, 94, 71, 40, 96, 49, 43, 44, 45, 46, 55, 48, 76, 50,
                                        78, 52, 53, 81, 55, 1, 12, 13, 14, 60, 16, 17, 23, 19, 20, 21, 65, 66, 67, 68,
                                        26, 13, 71, 106, 30, 14, 32, 33, 17, 35, 76, 37, 78, 73, 40, 81, 47, 43, 44, 45,
                                        46, 46, 48, 83, 50, 37, 52, 53, 53, 55, 37, 12, 13, 14, 60, 16, 17, 73, 19, 20,
                                        21, 101, 1, 52, 18, 26, 55, 83, 94, 30, 29, 32, 33, 36, 35, 38, 37, 17, 37, 40,
                                        96, 37, 43, 44, 45, 46, 17, 48, 27, 50, 49, 52, 53, 49, 55, 34, 12, 13, 14, 60,
                                        16, 17, 27, 19, 20, 21, 97, 98, 73, 34, 26, 13, 14, 37, 30, 17, 32, 33, 83, 35,
                                        42, 37, 14, 18, 40, 49, 37, 43, 44, 45, 46, 96, 48, 102, 50, 35, 52, 53, 49, 55,
                                        52, 12, 13, 14, 60, 16, 17, 77, 19, 20, 21, 46, 15, 55, 95, 26, 97, 98, 53, 30,
                                        23, 32, 33, 55, 35, 94, 37, 96, 73, 40, 73, 101, 43, 44, 45, 46, 24, 48, 83, 50,
                                        83, 52, 53, 17, 55, 92, 12, 13, 14, 60, 16, 17, 99, 19, 20, 21, 101, 12, 13, 46,
                                        26, 94, 17, 96, 30, 73, 32, 33, 1, 35, 54, 37, 17, 1, 40, 83, 1, 43, 44, 45, 46,
                                        38, 48, 11, 50, 18, 52, 53, 96, 55, 37, 12, 13, 14, 60, 16, 17, 77, 19, 20, 21,
                                        76, 1, 73, 29, 26, 81, 1, 73, 30, 17, 32, 33, 83, 35, 35, 37, 11, 83, 40, 73,
                                        101, 43, 44, 45, 46, 82, 48, 54, 50, 83, 52, 67, 27, 55, 70, 12, 13, 77, 60, 34,
                                        17, 14, 3, 4, 5, 6, 7, 8, 1, 2, 27, 12, 13, 77, 54, 16, 5, 34, 19, 20, 21, 101,
                                        102, 1, 2, 26, 17, 92, 82, 30, 11, 32, 33, 52, 99, 66, 82, 101, 17, 80, 71, 72,
                                        1, 74, 75, 76, 39, 40, 41, 83, 81, 81, 11, 84, 85, 97, 98, 73, 89, 90, 91, 77,
                                        93, 56, 57, 58, 59, 83, 96, 66, 94, 81, 103, 104, 71, 72, 94, 74, 75, 76, 39,
                                        40, 41, 81, 81, 101, 11, 84, 85, 2, 15, 81, 89, 90, 91, 1, 93, 56, 57, 58, 59,
                                        95, 27, 69, 9, 11, 94, 104, 66, 34, 1, 81, 37, 71, 72, 107, 74, 75, 76, 94, 78,
                                        27, 28, 81, 49, 107, 84, 85, 34, 107, 107, 89, 90, 91, 107, 93, 66, 28, 107,
                                        107, 107, 71, 72, 1, 74, 75, 76, 1, 39, 40, 41, 81, 107, 11, 84, 85, 107, 12,
                                        13, 89, 90, 91, 17, 93, 107, 56, 57, 58, 59, 27, 100, 107, 12, 13, 66, 107, 34,
                                        17, 107, 71, 72, 107, 74, 75, 76, 39, 40, 41, 107, 81, 107, 107, 84, 85, 107,
                                        107, 51, 89, 90, 91, 54, 93, 56, 57, 58, 59, 107, 107, 100, 66, 107, 51, 107,
                                        107, 71, 72, 1, 74, 75, 76, 107, 78, 107, 107, 81, 73, 11, 84, 85, 77, 5, 37,
                                        89, 90, 91, 83, 93, 12, 13, 14, 46, 16, 27, 49, 19, 20, 21, 107, 54, 34, 107,
                                        26, 5, 101, 107, 30, 107, 32, 33, 12, 13, 14, 107, 16, 107, 107, 19, 20, 21,
                                        107, 39, 40, 41, 26, 107, 107, 107, 30, 107, 32, 33, 107, 107, 107, 107, 60, 61,
                                        56, 57, 58, 59, 107, 107, 107, 66, 107, 107, 107, 107, 71, 72, 107, 74, 75, 76,
                                        1, 107, 60, 61, 81, 107, 107, 84, 85, 107, 11, 107, 89, 90, 91, 107, 93, 18,
                                        107, 66, 107, 1, 107, 100, 71, 72, 27, 74, 75, 76, 107, 11, 107, 34, 81, 73, 37,
                                        84, 85, 77, 107, 107, 89, 90, 91, 83, 93, 66, 49, 12, 13, 107, 71, 72, 17, 74,
                                        75, 76, 107, 39, 40, 41, 81, 101, 107, 84, 85, 107, 107, 107, 89, 90, 91, 107,
                                        93, 66, 56, 57, 58, 59, 71, 72, 107, 74, 75, 76, 107, 107, 51, 107, 81, 107,
                                        107, 84, 85, 107, 107, 107, 89, 90, 91, 66, 93, 1, 107, 107, 71, 72, 107, 74,
                                        75, 76, 107, 11, 107, 107, 81, 73, 107, 84, 85, 77, 107, 107, 89, 90, 91, 83,
                                        93, 66, 86, 87, 88, 107, 71, 72, 107, 74, 75, 76, 107, 39, 40, 41, 81, 101, 107,
                                        84, 85, 107, 107, 107, 89, 90, 91, 107, 93, 66, 56, 57, 58, 59, 71, 72, 107, 74,
                                        75, 76, 107, 107, 107, 107, 81, 107, 107, 84, 85, 107, 107, 107, 89, 90, 91, 66,
                                        93, 1, 107, 107, 71, 72, 107, 74, 75, 76, 107, 11, 107, 107, 81, 73, 107, 84,
                                        85, 77, 107, 107, 89, 90, 91, 83, 93, 66, 86, 87, 88, 107, 71, 72, 107, 74, 75,
                                        76, 107, 39, 40, 41, 81, 101, 107, 84, 85, 107, 107, 107, 89, 90, 91, 107, 93,
                                        66, 56, 57, 58, 59, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107, 81, 107, 107,
                                        84, 85, 107, 107, 107, 89, 90, 91, 66, 93, 1, 107, 107, 71, 72, 107, 74, 75, 76,
                                        107, 107, 107, 107, 81, 73, 107, 84, 85, 77, 107, 107, 89, 90, 91, 83, 93, 66,
                                        86, 87, 88, 107, 71, 72, 107, 74, 75, 76, 38, 39, 40, 41, 81, 101, 107, 84, 85,
                                        107, 107, 107, 89, 90, 91, 107, 93, 66, 56, 57, 58, 59, 71, 72, 107, 74, 75, 76,
                                        107, 107, 107, 107, 81, 107, 107, 84, 85, 107, 107, 107, 89, 90, 91, 66, 93, 1,
                                        107, 107, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107, 81, 73, 107, 84, 85, 77,
                                        107, 107, 89, 90, 91, 83, 93, 66, 86, 87, 88, 107, 71, 72, 107, 74, 75, 76, 38,
                                        39, 40, 41, 81, 101, 107, 84, 85, 107, 107, 107, 89, 90, 91, 107, 93, 66, 56,
                                        57, 58, 59, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107, 81, 107, 107, 84, 85,
                                        107, 107, 107, 89, 90, 91, 66, 93, 1, 107, 107, 71, 72, 107, 74, 75, 76, 107,
                                        107, 107, 107, 81, 73, 107, 84, 85, 77, 107, 107, 89, 90, 91, 83, 93, 66, 86,
                                        87, 88, 107, 71, 72, 107, 74, 75, 76, 107, 39, 40, 41, 81, 101, 107, 84, 85,
                                        107, 107, 107, 89, 90, 91, 107, 93, 66, 56, 57, 58, 59, 71, 72, 107, 74, 75, 76,
                                        107, 107, 107, 107, 81, 107, 107, 84, 85, 107, 107, 107, 89, 90, 91, 66, 93,
                                        107, 107, 107, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107, 81, 73, 107, 84, 85,
                                        77, 107, 107, 89, 90, 91, 83, 93, 66, 86, 87, 88, 107, 71, 72, 107, 74, 75, 76,
                                        107, 107, 107, 107, 81, 101, 107, 84, 85, 107, 107, 107, 89, 90, 91, 107, 93,
                                        66, 107, 107, 107, 107, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107, 81, 107,
                                        107, 84, 85, 107, 107, 107, 89, 90, 91, 66, 93, 107, 107, 107, 71, 72, 107, 74,
                                        75, 76, 107, 107, 107, 107, 81, 107, 107, 84, 85, 107, 107, 107, 89, 90, 91,
                                        107, 93, 66, 107, 107, 107, 107, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107,
                                        81, 107, 107, 84, 85, 107, 107, 107, 89, 90, 91, 107, 93, 66, 107, 107, 107,
                                        107, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107, 81, 107, 107, 84, 85, 107,
                                        107, 107, 89, 90, 91, 66, 93, 107, 107, 107, 71, 72, 107, 74, 75, 76, 107, 107,
                                        107, 107, 81, 107, 107, 84, 85, 107, 107, 107, 89, 90, 91, 107, 93, 66, 107,
                                        107, 107, 107, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107, 81, 107, 107, 84,
                                        85, 107, 107, 107, 89, 90, 91, 107, 93, 66, 107, 107, 107, 107, 71, 72, 107, 74,
                                        75, 76, 107, 107, 107, 107, 81, 107, 107, 84, 85, 107, 107, 107, 89, 90, 91, 66,
                                        93, 107, 107, 107, 71, 72, 107, 74, 75, 76, 107, 107, 107, 107, 81, 107, 107,
                                        84, 85, 1, 2, 107, 89, 90, 91, 107, 93, 66, 107, 107, 107, 107, 71, 72, 107, 74,
                                        75, 76, 107, 107, 107, 107, 81, 107, 107, 84, 85, 1, 107, 107, 89, 90, 91, 107,
                                        93, 37, 107, 39, 40, 41, 63, 64, 65, 66, 67, 68, 107, 49, 71, 107, 107, 25, 107,
                                        27, 56, 57, 58, 59, 107, 2, 34, 107, 107, 107, 107, 39, 40, 41, 107, 12, 13, 66,
                                        15, 107, 17, 18, 71, 72, 1, 74, 107, 76, 56, 57, 58, 59, 81, 107, 11, 11, 85,
                                        107, 12, 13, 89, 90, 91, 17, 93, 107, 107, 23, 107, 46, 27, 27, 49, 27, 51, 29,
                                        53, 34, 34, 107, 34, 107, 39, 40, 41, 107, 107, 107, 66, 107, 1, 47, 107, 71,
                                        72, 107, 74, 107, 76, 56, 57, 58, 59, 81, 107, 107, 107, 85, 107, 12, 13, 89,
                                        90, 91, 17, 93, 27, 107, 107, 107, 107, 107, 107, 34, 27, 107, 29, 66, 39, 40,
                                        41, 34, 71, 72, 107, 74, 107, 76, 107, 107, 107, 107, 81, 11, 107, 56, 57, 58,
                                        59, 107, 89, 90, 91, 107, 93, 23, 107, 66, 107, 27, 107, 107, 71, 72, 107, 74,
                                        34, 76, 66, 107, 107, 107, 81, 71, 72, 107, 74, 107, 76, 47, 89, 90, 91, 81, 93,
                                        107, 107, 107, 107, 107, 107, 89, 90, 91, 66, 93, 107, 107, 107, 71, 72, 107,
                                        74, 107, 76, 107, 107, 107, 107, 81, 107, 107, 2, 107, 107, 107, 107, 89, 90,
                                        91, 107, 93, 12, 13, 66, 15, 107, 17, 18, 71, 72, 107, 74, 107, 76, 107, 107,
                                        107, 107, 81, 107, 107, 2, 107, 107, 107, 107, 89, 90, 91, 107, 93, 12, 13, 107,
                                        107, 46, 17, 18, 49, 66, 51, 2, 53, 1, 71, 72, 107, 74, 107, 76, 107, 12, 13,
                                        107, 81, 107, 17, 18, 107, 107, 107, 107, 89, 90, 91, 46, 93, 107, 49, 107, 51,
                                        107, 53, 54, 107, 1, 107, 107, 107, 107, 107, 39, 40, 41, 107, 46, 107, 107, 49,
                                        107, 51, 107, 53, 107, 107, 2, 22, 107, 56, 57, 58, 59, 107, 61, 107, 12, 13,
                                        107, 107, 107, 17, 18, 107, 39, 40, 41, 12, 13, 107, 107, 107, 17, 18, 107, 107,
                                        107, 107, 107, 107, 107, 56, 57, 58, 59, 107, 107, 107, 107, 107, 46, 107, 107,
                                        49, 11, 51, 107, 53, 107, 107, 107, 46, 107, 107, 49, 22, 51, 24, 53, 107, 27,
                                        107, 107, 107, 107, 107, 107, 34, 107, 36, 107, 38, 107, 107, 107, 107, 107,
                                        107, 107, 46,);

    const YY_SHIFT_USE_DFLT = - 15;

    const YY_SHIFT_MAX = 238;

    static public $yy_shift_ofst = array(499, 393, 78, 393, 348, 78, 78, 348, - 12, - 12, 33, 78, 78, 78, 78, 168, 78,
                                         78, 78, 213, 123, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 303, 78, 78, 78,
                                         168, 258, 258, 438, 438, 438, 438, 438, 438, 1609, 1660, 1706, 1706, 1706,
                                         1706, 1706, 499, 1912, 1153, 609, 541, 507, 989, 907, 825, 1071, 646, 1880,
                                         1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 731,
                                         731, 140, 725, 804, 230, 465, 280, 160, 747, 1714, 1663, 483, 483, 160, 280,
                                         280, 324, 160, 522, 594, 1661, 1749, 642, 715, 317, 842, 40, 404, 3, 144, 404,
                                         - 5, 460, 327, 431, 161, 294, 147, 147, 426, - 5, 434, 223, 223, 265, 223, 223,
                                         223, 223, 223, 223, 265, 223, - 15, 1827, 1857, 1640, 1877, 1931, 1942, 92,
                                         645, 11, 90, - 5, 70, - 5, - 5, - 5, - 5, - 5, - 5, - 5, - 5, - 5, - 5, 214,
                                         - 5, 70, - 5, 70, - 5, - 5, - 5, - 5, - 5, 124, 124, 227, 124, 356, 124, 214,
                                         124, 124, - 5, 70, 124, 124, 223, 223, 595, 587, 587, 223, 265, 232, 223, 265,
                                         265, 223, - 15, - 15, - 15, - 15, - 15, 1581, 1970, 575, 694, 660, 260, 118,
                                         73, - 6, 96, 256, 295, 308, 145, 44, 110, 208, 263, - 14, 99, 439, 232, 519,
                                         521, 511, 509, 487, 83, 187, 101, 372, 279, 0, 297, 288, 481, 452, 371, 307,
                                         319, 385, 412, 414, 433, 375, 402,);

    const YY_REDUCE_USE_DFLT = - 67;

    const YY_REDUCE_MAX = 192;

    static public $yy_reduce_ofst = array(1560, 469, 608, 503, 542, 570, 728, 643, 922, 1278, 1360, 1060, 950, 1032,
                                          1086, 896, 868, 1004, 786, 1414, 1332, 1114, 1524, 1168, 1224, 1250, 1196,
                                          1142, 1306, 1470, 1496, 1388, 1442, 978, 758, 840, 814, 1588, 1639, 1745,
                                          1719, 1678, 1708, 1775, 1811, 1259, 931, 931, 1013, 1095, 849, 1177, 170,
                                          - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26,
                                          - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 26, - 66,
                                          46, 652, - 37, 484, 767, - 7, 136, 351, 113, 203, 254, 141, 314, 179, 278,
                                          173, 420, 289, 394, 394, 289, 289, 20, 290, 228, 290, 424, 228, 326, 406, 289,
                                          384, 289, 228, 316, 312, 435, 379, 389, 289, 289, 436, 458, 289, 289, 289,
                                          289, 289, 289, 228, 289, 289, 476, 476, 476, 476, 476, 476, 502, 472, 476,
                                          476, 466, 470, 466, 466, 466, 466, 466, 466, 466, 466, 466, 466, 482, 466,
                                          490, 466, 510, 466, 466, 466, 466, 466, 506, 506, 512, 506, 459, 506, 525,
                                          506, 506, 466, 530, 506, 506, 28, 28, 534, 250, 250, 28, - 56, 193, 28, - 56,
                                          - 56, 28, 112, - 27, 454, 403, 446,);

    static public $yyExpectedTokens = array(array(3, 4, 5, 6, 7, 8, 12, 13, 16, 19, 20, 21, 26, 30, 32, 33,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 31, 32, 33, 35, 37, 40, 43,
                                                  44, 45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 31, 32, 33, 35, 37, 40, 43,
                                                  44, 45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 54, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 53, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 55, 60,),
                                            array(12, 13, 14, 16, 17, 19, 20, 21, 26, 30, 32, 33, 35, 37, 40, 43, 44,
                                                  45, 46, 48, 50, 52, 55, 60,),
                                            array(1, 25, 27, 34, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 11, 27, 34, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 27, 34, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 27, 34, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 27, 34, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 27, 34, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 27, 34, 39, 40, 41, 56, 57, 58, 59,),
                                            array(3, 4, 5, 6, 7, 8, 12, 13, 16, 19, 20, 21, 26, 30, 32, 33,),
                                            array(1, 22, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 38, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 28, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 11, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 2, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 11, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 11, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 11, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 38, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 54, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59, 61,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,),
                                            array(1, 39, 40, 41, 56, 57, 58, 59,), array(39, 40, 41, 56, 57, 58, 59,),
                                            array(39, 40, 41, 56, 57, 58, 59,), array(14, 17, 50, 52, 55,),
                                            array(5, 12, 13, 14, 16, 19, 20, 21, 26, 30, 32, 33, 60, 61,),
                                            array(1, 11, 18, 27, 34, 37, 49,), array(14, 17, 52, 55,),
                                            array(1, 11, 27, 34,), array(1, 27, 34,), array(14, 37, 55,),
                                            array(5, 12, 13, 14, 16, 19, 20, 21, 26, 30, 32, 33, 60, 61,),
                                            array(12, 13, 17, 27, 29, 34,), array(12, 13, 17, 27, 29, 34,),
                                            array(12, 13, 17, 27, 34,), array(12, 13, 17, 27, 34,), array(14, 37, 55,),
                                            array(1, 27, 34,), array(1, 27, 34,), array(18, 46, 53,),
                                            array(14, 37, 55,), array(1, 2,), array(1, 11, 27, 28, 34,),
                                            array(11, 23, 27, 34, 47,), array(11, 23, 27, 34, 47,),
                                            array(1, 11, 27, 34,), array(1, 11, 27, 34,), array(13, 14, 17, 55,),
                                            array(12, 13, 17, 51,), array(15, 18, 49,), array(12, 13, 17,),
                                            array(8, 9, 10,), array(15, 18, 49,), array(12, 13, 17,), array(27, 34,),
                                            array(1, 54,), array(14, 55,), array(1, 11,), array(18, 49,),
                                            array(27, 34,), array(14, 17,), array(14, 17,), array(1, 18,),
                                            array(27, 34,), array(1, 29,), array(1,), array(1,), array(18,), array(1,),
                                            array(1,), array(1,), array(1,), array(1,), array(1,), array(18,),
                                            array(1,), array(), array(2, 12, 13, 15, 17, 18, 46, 49, 51, 53,),
                                            array(2, 12, 13, 17, 18, 46, 49, 51, 53, 54,),
                                            array(2, 12, 13, 15, 17, 18, 46, 49, 51, 53,),
                                            array(2, 12, 13, 17, 18, 46, 49, 51, 53,),
                                            array(2, 12, 13, 17, 18, 46, 49, 51, 53,),
                                            array(12, 13, 17, 18, 46, 49, 51, 53,), array(13, 14, 17, 35, 55,),
                                            array(12, 13, 17, 51,), array(15, 46, 53,), array(12, 13, 17,),
                                            array(27, 34,), array(14, 55,), array(27, 34,), array(27, 34,),
                                            array(27, 34,), array(27, 34,), array(27, 34,), array(27, 34,),
                                            array(27, 34,), array(27, 34,), array(27, 34,), array(27, 34,),
                                            array(46, 53,), array(27, 34,), array(14, 55,), array(27, 34,),
                                            array(14, 55,), array(27, 34,), array(27, 34,), array(27, 34,),
                                            array(27, 34,), array(27, 34,), array(46, 53,), array(46, 53,),
                                            array(13, 37,), array(46, 53,), array(15, 23,), array(46, 53,),
                                            array(46, 53,), array(46, 53,), array(46, 53,), array(27, 34,),
                                            array(14, 55,), array(46, 53,), array(46, 53,), array(1,), array(1,),
                                            array(9,), array(2,), array(2,), array(1,), array(18,), array(37,),
                                            array(1,), array(18,), array(18,), array(1,), array(), array(), array(),
                                            array(), array(), array(1, 2, 37, 39, 40, 41, 49, 56, 57, 58, 59,),
                                            array(11, 22, 24, 27, 34, 36, 38, 46,), array(11, 15, 27, 34, 37, 49,),
                                            array(37, 46, 49, 54,), array(12, 13, 17, 51,), array(29, 37, 49,),
                                            array(23, 47, 54,), array(23, 47, 61,), array(22, 36,), array(36, 54,),
                                            array(36, 38,), array(37, 49,), array(37, 49,), array(46, 54,),
                                            array(36, 38,), array(36, 38,), array(23, 47,), array(37, 49,),
                                            array(17, 51,), array(15, 46,), array(35,), array(37,), array(11,),
                                            array(17,), array(5,), array(17,), array(14,), array(17,), array(17,),
                                            array(15,), array(46,), array(17,), array(17,), array(42,), array(17,),
                                            array(52,), array(17,), array(24,), array(52,), array(35,), array(17,),
                                            array(37,), array(17,), array(54,), array(54,), array(38,), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),);

    static public $yy_default = array(339, 517, 496, 532, 532, 496, 496, 532, 532, 532, 532, 532, 532, 532, 532, 532,
                                      532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532,
                                      532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 532, 398, 532, 361,
                                      398, 398, 374, 364, 336, 532, 532, 403, 532, 532, 532, 532, 532, 532, 532, 532,
                                      400, 494, 518, 403, 409, 520, 379, 519, 405, 495, 410, 420, 425, 424, 532, 532,
                                      436, 532, 412, 398, 532, 532, 398, 398, 398, 398, 532, 398, 398, 508, 532, 388,
                                      412, 426, 426, 412, 412, 532, 461, 451, 461, 532, 451, 461, 398, 412, 532, 412,
                                      451, 398, 532, 532, 392, 376, 412, 419, 394, 505, 427, 416, 428, 429, 415, 423,
                                      451, 412, 503, 450, 450, 450, 450, 450, 450, 532, 463, 477, 461, 384, 532, 372,
                                      383, 371, 366, 365, 368, 370, 360, 362, 385, 454, 386, 532, 358, 532, 387, 377,
                                      382, 381, 375, 457, 486, 461, 487, 532, 489, 456, 455, 488, 378, 532, 458, 459,
                                      445, 393, 352, 497, 498, 389, 506, 461, 418, 509, 483, 395, 461, 461, 502, 502,
                                      502, 436, 432, 436, 436, 462, 436, 426, 426, 532, 532, 532, 532, 436, 432, 532,
                                      532, 426, 446, 532, 432, 532, 477, 532, 532, 344, 532, 532, 532, 532, 532, 432,
                                      532, 532, 438, 532, 532, 532, 406, 532, 434, 532, 507, 532, 441, 532, 532, 340,
                                      504, 492, 338, 337, 491, 438, 467, 482, 396, 341, 441, 477, 413, 349, 343, 350,
                                      466, 351, 411, 348, 431, 346, 345, 347, 433, 407, 465, 355, 464, 356, 414, 437,
                                      399, 353, 435, 380, 354, 342, 421, 417, 513, 479, 440, 439, 480, 512, 390, 511,
                                      510, 523, 522, 521, 481, 484, 493, 500, 478, 453, 485, 499, 452, 529, 430, 501,
                                      528, 391, 526, 525, 443, 373, 460, 490, 444, 422, 473, 471, 476, 442, 470, 469,
                                      468, 447, 449, 524, 475, 531, 530, 527, 448, 397, 515, 474, 516, 472, 514, 367,);

    const YYNOCODE = 108;

    const YYSTACKDEPTH = 500;

    const YYNSTATE = 336;

    const YYNRULE = 196;

    const YYERRORSYMBOL = 62;

    const YYERRSYMDT = 'yy0';

    const YYFALLBACK = 0;

    public static $yyFallback = array();

    public function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        $this->yyTraceFILE = $TraceFILE;
        $this->yyTracePrompt = $zTracePrompt;
    }

    public function PrintTrace()
    {
        $this->yyTraceFILE = fopen('php://output', 'w');
        $this->yyTracePrompt = '<br>';
    }

    public $yyTraceFILE;

    public $yyTracePrompt;

    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array('$', 'VERT', 'COLON', 'PHP', 'NOCACHE', 'TEXT', 'STRIPON', 'STRIPOFF', 'LITERALSTART',
                                'LITERALEND', 'LITERAL', 'RDEL', 'SIMPELOUTPUT', 'LDEL', 'DOLLARID', 'EQUAL',
                                'SIMPLETAG', 'ID', 'PTR', 'LDELMAKENOCACHE', 'LDELIF', 'LDELFOR', 'SEMICOLON', 'INCDEC',
                                'TO', 'STEP', 'LDELFOREACH', 'SPACE', 'AS', 'APTR', 'LDELSETFILTER',
                                'SMARTYBLOCKCHILDPARENT', 'CLOSETAG', 'LDELSLASH', 'ATTR', 'INTEGER', 'COMMA', 'OPENP',
                                'CLOSEP', 'MATH', 'UNIMATH', 'ISIN', 'QMARK', 'NOT', 'TYPECAST', 'HEX', 'DOT',
                                'INSTANCEOF', 'SINGLEQUOTESTRING', 'DOUBLECOLON', 'NAMESPACE', 'AT', 'HATCH', 'OPENB',
                                'CLOSEB', 'DOLLAR', 'LOGOP', 'SLOGOP', 'TLOGOP', 'SINGLECOND', 'QUOTE', 'BACKTICK',
                                'error', 'start', 'template', 'template_element', 'smartytag', 'literal',
                                'text_content', 'literal_elements', 'literal_element', 'tag', 'variable', 'attributes',
                                'value', 'expr', 'varindexed', 'modifierlist', 'statement', 'statements', 'foraction',
                                'varvar', 'modparameters', 'attribute', 'ternary', 'array', 'tlop', 'lop', 'scond',
                                'function', 'ns1', 'doublequoted_with_quotes', 'static_class_access', 'object',
                                'arrayindex', 'indexdef', 'varvarele', 'objectchain', 'objectelement', 'method',
                                'params', 'modifier', 'modparameter', 'arrayelements', 'arrayelement', 'doublequoted',
                                'doublequotedcontent',);

    public static $yyRuleName = array('start ::= template', 'template ::= template_element',
                                      'template ::= template template_element', 'template ::=',
                                      'template_element ::= smartytag', 'template_element ::= literal',
                                      'template_element ::= PHP', 'template_element ::= NOCACHE',
                                      'template_element ::= text_content', 'text_content ::= TEXT',
                                      'text_content ::= text_content TEXT', 'template_element ::= STRIPON',
                                      'template_element ::= STRIPOFF', 'literal ::= LITERALSTART LITERALEND',
                                      'literal ::= LITERALSTART literal_elements LITERALEND',
                                      'literal_elements ::= literal_elements literal_element', 'literal_elements ::=',
                                      'literal_element ::= literal', 'literal_element ::= LITERAL',
                                      'smartytag ::= tag RDEL', 'smartytag ::= SIMPELOUTPUT', 'tag ::= LDEL variable',
                                      'tag ::= LDEL variable attributes', 'tag ::= LDEL value',
                                      'tag ::= LDEL value attributes', 'tag ::= LDEL expr',
                                      'tag ::= LDEL expr attributes', 'tag ::= LDEL DOLLARID EQUAL value',
                                      'tag ::= LDEL DOLLARID EQUAL expr', 'tag ::= LDEL DOLLARID EQUAL expr attributes',
                                      'tag ::= LDEL varindexed EQUAL expr attributes', 'smartytag ::= SIMPLETAG',
                                      'tag ::= LDEL ID attributes', 'tag ::= LDEL ID',
                                      'tag ::= LDEL ID modifierlist attributes', 'tag ::= LDEL ID PTR ID attributes',
                                      'tag ::= LDEL ID PTR ID modifierlist attributes',
                                      'tag ::= LDELMAKENOCACHE DOLLARID', 'tag ::= LDELIF expr',
                                      'tag ::= LDELIF expr attributes', 'tag ::= LDELIF statement',
                                      'tag ::= LDELIF statement attributes',
                                      'tag ::= LDELFOR statements SEMICOLON expr SEMICOLON varindexed foraction attributes',
                                      'foraction ::= EQUAL expr', 'foraction ::= INCDEC',
                                      'tag ::= LDELFOR statement TO expr attributes',
                                      'tag ::= LDELFOR statement TO expr STEP expr attributes',
                                      'tag ::= LDELFOREACH attributes',
                                      'tag ::= LDELFOREACH SPACE value AS varvar attributes',
                                      'tag ::= LDELFOREACH SPACE value AS varvar APTR varvar attributes',
                                      'tag ::= LDELFOREACH SPACE expr AS varvar attributes',
                                      'tag ::= LDELFOREACH SPACE expr AS varvar APTR varvar attributes',
                                      'tag ::= LDELSETFILTER ID modparameters',
                                      'tag ::= LDELSETFILTER ID modparameters modifierlist',
                                      'tag ::= LDEL SMARTYBLOCKCHILDPARENT', 'smartytag ::= CLOSETAG',
                                      'tag ::= LDELSLASH ID', 'tag ::= LDELSLASH ID modifierlist',
                                      'tag ::= LDELSLASH ID PTR ID', 'tag ::= LDELSLASH ID PTR ID modifierlist',
                                      'attributes ::= attributes attribute', 'attributes ::= attribute',
                                      'attributes ::=', 'attribute ::= SPACE ID EQUAL ID', 'attribute ::= ATTR expr',
                                      'attribute ::= ATTR value', 'attribute ::= SPACE ID', 'attribute ::= SPACE expr',
                                      'attribute ::= SPACE value', 'attribute ::= SPACE INTEGER EQUAL expr',
                                      'statements ::= statement', 'statements ::= statements COMMA statement',
                                      'statement ::= DOLLARID EQUAL INTEGER', 'statement ::= DOLLARID EQUAL expr',
                                      'statement ::= varindexed EQUAL expr', 'statement ::= OPENP statement CLOSEP',
                                      'expr ::= value', 'expr ::= ternary', 'expr ::= DOLLARID COLON ID',
                                      'expr ::= expr MATH value', 'expr ::= expr UNIMATH value', 'expr ::= array',
                                      'expr ::= expr modifierlist', 'expr ::= expr tlop value',
                                      'expr ::= expr lop expr', 'expr ::= expr scond', 'expr ::= expr ISIN array',
                                      'expr ::= expr ISIN value',
                                      'ternary ::= OPENP expr CLOSEP QMARK DOLLARID COLON expr',
                                      'ternary ::= OPENP expr CLOSEP QMARK expr COLON expr', 'value ::= variable',
                                      'value ::= UNIMATH value', 'value ::= NOT value', 'value ::= TYPECAST value',
                                      'value ::= variable INCDEC', 'value ::= HEX', 'value ::= INTEGER',
                                      'value ::= INTEGER DOT INTEGER', 'value ::= INTEGER DOT', 'value ::= DOT INTEGER',
                                      'value ::= ID', 'value ::= function', 'value ::= OPENP expr CLOSEP',
                                      'value ::= variable INSTANCEOF ns1', 'value ::= variable INSTANCEOF variable',
                                      'value ::= SINGLEQUOTESTRING', 'value ::= doublequoted_with_quotes',
                                      'value ::= varindexed DOUBLECOLON static_class_access', 'value ::= smartytag',
                                      'value ::= value modifierlist', 'value ::= NAMESPACE',
                                      'value ::= ns1 DOUBLECOLON static_class_access', 'ns1 ::= ID',
                                      'ns1 ::= NAMESPACE', 'variable ::= DOLLARID', 'variable ::= varindexed',
                                      'variable ::= varvar AT ID', 'variable ::= object', 'variable ::= HATCH ID HATCH',
                                      'variable ::= HATCH ID HATCH arrayindex', 'variable ::= HATCH variable HATCH',
                                      'variable ::= HATCH variable HATCH arrayindex',
                                      'varindexed ::= DOLLARID arrayindex', 'varindexed ::= varvar arrayindex',
                                      'arrayindex ::= arrayindex indexdef', 'arrayindex ::=',
                                      'indexdef ::= DOT DOLLARID', 'indexdef ::= DOT varvar',
                                      'indexdef ::= DOT varvar AT ID', 'indexdef ::= DOT ID',
                                      'indexdef ::= DOT INTEGER', 'indexdef ::= DOT LDEL expr RDEL',
                                      'indexdef ::= OPENB ID CLOSEB', 'indexdef ::= OPENB ID DOT ID CLOSEB',
                                      'indexdef ::= OPENB SINGLEQUOTESTRING CLOSEB',
                                      'indexdef ::= OPENB INTEGER CLOSEB', 'indexdef ::= OPENB DOLLARID CLOSEB',
                                      'indexdef ::= OPENB variable CLOSEB', 'indexdef ::= OPENB value CLOSEB',
                                      'indexdef ::= OPENB expr CLOSEB', 'indexdef ::= OPENB CLOSEB',
                                      'varvar ::= DOLLARID', 'varvar ::= DOLLAR', 'varvar ::= varvar varvarele',
                                      'varvarele ::= ID', 'varvarele ::= SIMPELOUTPUT', 'varvarele ::= LDEL expr RDEL',
                                      'object ::= varindexed objectchain', 'objectchain ::= objectelement',
                                      'objectchain ::= objectchain objectelement',
                                      'objectelement ::= PTR ID arrayindex', 'objectelement ::= PTR varvar arrayindex',
                                      'objectelement ::= PTR LDEL expr RDEL arrayindex',
                                      'objectelement ::= PTR ID LDEL expr RDEL arrayindex',
                                      'objectelement ::= PTR method', 'function ::= ns1 OPENP params CLOSEP',
                                      'method ::= ID OPENP params CLOSEP', 'method ::= DOLLARID OPENP params CLOSEP',
                                      'params ::= params COMMA expr', 'params ::= expr', 'params ::=',
                                      'modifierlist ::= modifierlist modifier modparameters',
                                      'modifierlist ::= modifier modparameters', 'modifier ::= VERT AT ID',
                                      'modifier ::= VERT ID', 'modparameters ::= modparameters modparameter',
                                      'modparameters ::=', 'modparameter ::= COLON value',
                                      'modparameter ::= COLON array', 'static_class_access ::= method',
                                      'static_class_access ::= method objectchain', 'static_class_access ::= ID',
                                      'static_class_access ::= DOLLARID arrayindex',
                                      'static_class_access ::= DOLLARID arrayindex objectchain', 'lop ::= LOGOP',
                                      'lop ::= SLOGOP', 'tlop ::= TLOGOP', 'scond ::= SINGLECOND',
                                      'array ::= OPENB arrayelements CLOSEB', 'arrayelements ::= arrayelement',
                                      'arrayelements ::= arrayelements COMMA arrayelement', 'arrayelements ::=',
                                      'arrayelement ::= value APTR expr', 'arrayelement ::= ID APTR expr',
                                      'arrayelement ::= expr', 'doublequoted_with_quotes ::= QUOTE QUOTE',
                                      'doublequoted_with_quotes ::= QUOTE doublequoted QUOTE',
                                      'doublequoted ::= doublequoted doublequotedcontent',
                                      'doublequoted ::= doublequotedcontent',
                                      'doublequotedcontent ::= BACKTICK variable BACKTICK',
                                      'doublequotedcontent ::= BACKTICK expr BACKTICK',
                                      'doublequotedcontent ::= DOLLARID', 'doublequotedcontent ::= LDEL variable RDEL',
                                      'doublequotedcontent ::= LDEL expr RDEL', 'doublequotedcontent ::= smartytag',
                                      'doublequotedcontent ::= TEXT',);

    public function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[ $tokenType ];
        } else {
            return "Unknown";
        }
    }

    public static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:
                break;   /* If no destructor action specified: do nothing */
        }
    }

    public function yy_pop_parser_stack()
    {
        if (empty($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if ($this->yyTraceFILE && $this->yyidx >= 0) {
            fwrite($this->yyTraceFILE, $this->yyTracePrompt . 'Popping ' . $this->yyTokenName[ $yytos->major ] . "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx --;

        return $yymajor;
    }

    public function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource($this->yyTraceFILE)) {
            fclose($this->yyTraceFILE);
        }
    }

    public function yy_get_expected_tokens($token)
    {
        static $res3 = array();
        static $res4 = array();
        $state = $this->yystack[ $this->yyidx ]->stateno;
        $expected = self::$yyExpectedTokens[ $state ];
        if (isset($res3[ $state ][ $token ])) {
            if ($res3[ $state ][ $token ]) {
                return $expected;
            }
        } else {
            if ($res3[ $state ][ $token ] = in_array($token, self::$yyExpectedTokens[ $state ], true)) {
                return $expected;
            }
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done ++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[ $yyruleno ][ 1 ];
                    $nextstate = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno,
                                                              self::$yyRuleInfo[ $yyruleno ][ 0 ]);
                    if (isset(self::$yyExpectedTokens[ $nextstate ])) {
                        $expected = array_merge($expected, self::$yyExpectedTokens[ $nextstate ]);
                        if (isset($res4[ $nextstate ][ $token ])) {
                            if ($res4[ $nextstate ][ $token ]) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        } else {
                            if ($res4[ $nextstate ][ $token ] =
                                in_array($token, self::$yyExpectedTokens[ $nextstate ], true)
                            ) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx ++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[ $yyruleno ][ 0 ];
                        $this->yystack[ $this->yyidx ] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                }
                while (true);
            }
            break;
        }
        while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return array_unique($expected);
    }

    public function yy_is_expected_token($token)
    {
        static $res = array();
        static $res2 = array();
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[ $this->yyidx ]->stateno;
        if (isset($res[ $state ][ $token ])) {
            if ($res[ $state ][ $token ]) {
                return true;
            }
        } else {
            if ($res[ $state ][ $token ] = in_array($token, self::$yyExpectedTokens[ $state ], true)) {
                return true;
            }
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done ++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[ $yyruleno ][ 1 ];
                    $nextstate = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno,
                                                              self::$yyRuleInfo[ $yyruleno ][ 0 ]);
                    if (isset($res2[ $nextstate ][ $token ])) {
                        if ($res2[ $nextstate ][ $token ]) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    } else {
                        if ($res2[ $nextstate ][ $token ] = (isset(self::$yyExpectedTokens[ $nextstate ]) &&
                                                             in_array($token, self::$yyExpectedTokens[ $nextstate ],
                                                                      true))
                        ) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx ++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[ $yyruleno ][ 0 ];
                        $this->yystack[ $this->yyidx ] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                }
                while (true);
            }
            break;
        }
        while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return true;
    }

    public function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[ $this->yyidx ]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[ $stateno ])) {
            // no shift actions
            return self::$yy_default[ $stateno ];
        }
        $i = self::$yy_shift_ofst[ $stateno ];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[ $stateno ];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB || self::$yy_lookahead[ $i ] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback) &&
                ($iFallback = self::$yyFallback[ $iLookAhead ]) != 0
            ) {
                if ($this->yyTraceFILE) {
                    fwrite($this->yyTraceFILE,
                           $this->yyTracePrompt . "FALLBACK " . $this->yyTokenName[ $iLookAhead ] . " => " .
                           $this->yyTokenName[ $iFallback ] . "\n");
                }

                return $this->yy_find_shift_action($iFallback);
            }

            return self::$yy_default[ $stateno ];
        } else {
            return self::$yy_action[ $i ];
        }
    }

    public function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[ $stateno ])) {
            return self::$yy_default[ $stateno ];
        }
        $i = self::$yy_reduce_ofst[ $stateno ];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[ $stateno ];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB || self::$yy_lookahead[ $i ] != $iLookAhead) {
            return self::$yy_default[ $stateno ];
        } else {
            return self::$yy_action[ $i ];
        }
    }

    public function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx ++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx --;
            if ($this->yyTraceFILE) {
                fprintf($this->yyTraceFILE, "%sStack Overflow!\n", $this->yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            #line 207 "../smarty/lexer/smarty_internal_templateparser.y"

            $this->internalError = true;
            $this->compiler->trigger_template_error("Stack overflow in template parser");

            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        $this->yystack[] = $yytos;
        if ($this->yyTraceFILE && $this->yyidx > 0) {
            fprintf($this->yyTraceFILE, "%sShift %d\n", $this->yyTracePrompt, $yyNewState);
            fprintf($this->yyTraceFILE, "%sStack:", $this->yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i ++) {
                fprintf($this->yyTraceFILE, " %s", $this->yyTokenName[ $this->yystack[ $i ]->major ]);
            }
            fwrite($this->yyTraceFILE, "\n");
        }
    }

    public static $yyRuleInfo = array(array(0 => 63, 1 => 1), array(0 => 64, 1 => 1), array(0 => 64, 1 => 2),
                                      array(0 => 64, 1 => 0), array(0 => 65, 1 => 1), array(0 => 65, 1 => 1),
                                      array(0 => 65, 1 => 1), array(0 => 65, 1 => 1), array(0 => 65, 1 => 1),
                                      array(0 => 68, 1 => 1), array(0 => 68, 1 => 2), array(0 => 65, 1 => 1),
                                      array(0 => 65, 1 => 1), array(0 => 67, 1 => 2), array(0 => 67, 1 => 3),
                                      array(0 => 69, 1 => 2), array(0 => 69, 1 => 0), array(0 => 70, 1 => 1),
                                      array(0 => 70, 1 => 1), array(0 => 66, 1 => 2), array(0 => 66, 1 => 1),
                                      array(0 => 71, 1 => 2), array(0 => 71, 1 => 3), array(0 => 71, 1 => 2),
                                      array(0 => 71, 1 => 3), array(0 => 71, 1 => 2), array(0 => 71, 1 => 3),
                                      array(0 => 71, 1 => 4), array(0 => 71, 1 => 4), array(0 => 71, 1 => 5),
                                      array(0 => 71, 1 => 5), array(0 => 66, 1 => 1), array(0 => 71, 1 => 3),
                                      array(0 => 71, 1 => 2), array(0 => 71, 1 => 4), array(0 => 71, 1 => 5),
                                      array(0 => 71, 1 => 6), array(0 => 71, 1 => 2), array(0 => 71, 1 => 2),
                                      array(0 => 71, 1 => 3), array(0 => 71, 1 => 2), array(0 => 71, 1 => 3),
                                      array(0 => 71, 1 => 8), array(0 => 80, 1 => 2), array(0 => 80, 1 => 1),
                                      array(0 => 71, 1 => 5), array(0 => 71, 1 => 7), array(0 => 71, 1 => 2),
                                      array(0 => 71, 1 => 6), array(0 => 71, 1 => 8), array(0 => 71, 1 => 6),
                                      array(0 => 71, 1 => 8), array(0 => 71, 1 => 3), array(0 => 71, 1 => 4),
                                      array(0 => 71, 1 => 2), array(0 => 66, 1 => 1), array(0 => 71, 1 => 2),
                                      array(0 => 71, 1 => 3), array(0 => 71, 1 => 4), array(0 => 71, 1 => 5),
                                      array(0 => 73, 1 => 2), array(0 => 73, 1 => 1), array(0 => 73, 1 => 0),
                                      array(0 => 83, 1 => 4), array(0 => 83, 1 => 2), array(0 => 83, 1 => 2),
                                      array(0 => 83, 1 => 2), array(0 => 83, 1 => 2), array(0 => 83, 1 => 2),
                                      array(0 => 83, 1 => 4), array(0 => 79, 1 => 1), array(0 => 79, 1 => 3),
                                      array(0 => 78, 1 => 3), array(0 => 78, 1 => 3), array(0 => 78, 1 => 3),
                                      array(0 => 78, 1 => 3), array(0 => 75, 1 => 1), array(0 => 75, 1 => 1),
                                      array(0 => 75, 1 => 3), array(0 => 75, 1 => 3), array(0 => 75, 1 => 3),
                                      array(0 => 75, 1 => 1), array(0 => 75, 1 => 2), array(0 => 75, 1 => 3),
                                      array(0 => 75, 1 => 3), array(0 => 75, 1 => 2), array(0 => 75, 1 => 3),
                                      array(0 => 75, 1 => 3), array(0 => 84, 1 => 7), array(0 => 84, 1 => 7),
                                      array(0 => 74, 1 => 1), array(0 => 74, 1 => 2), array(0 => 74, 1 => 2),
                                      array(0 => 74, 1 => 2), array(0 => 74, 1 => 2), array(0 => 74, 1 => 1),
                                      array(0 => 74, 1 => 1), array(0 => 74, 1 => 3), array(0 => 74, 1 => 2),
                                      array(0 => 74, 1 => 2), array(0 => 74, 1 => 1), array(0 => 74, 1 => 1),
                                      array(0 => 74, 1 => 3), array(0 => 74, 1 => 3), array(0 => 74, 1 => 3),
                                      array(0 => 74, 1 => 1), array(0 => 74, 1 => 1), array(0 => 74, 1 => 3),
                                      array(0 => 74, 1 => 1), array(0 => 74, 1 => 2), array(0 => 74, 1 => 1),
                                      array(0 => 74, 1 => 3), array(0 => 90, 1 => 1), array(0 => 90, 1 => 1),
                                      array(0 => 72, 1 => 1), array(0 => 72, 1 => 1), array(0 => 72, 1 => 3),
                                      array(0 => 72, 1 => 1), array(0 => 72, 1 => 3), array(0 => 72, 1 => 4),
                                      array(0 => 72, 1 => 3), array(0 => 72, 1 => 4), array(0 => 76, 1 => 2),
                                      array(0 => 76, 1 => 2), array(0 => 94, 1 => 2), array(0 => 94, 1 => 0),
                                      array(0 => 95, 1 => 2), array(0 => 95, 1 => 2), array(0 => 95, 1 => 4),
                                      array(0 => 95, 1 => 2), array(0 => 95, 1 => 2), array(0 => 95, 1 => 4),
                                      array(0 => 95, 1 => 3), array(0 => 95, 1 => 5), array(0 => 95, 1 => 3),
                                      array(0 => 95, 1 => 3), array(0 => 95, 1 => 3), array(0 => 95, 1 => 3),
                                      array(0 => 95, 1 => 3), array(0 => 95, 1 => 3), array(0 => 95, 1 => 2),
                                      array(0 => 81, 1 => 1), array(0 => 81, 1 => 1), array(0 => 81, 1 => 2),
                                      array(0 => 96, 1 => 1), array(0 => 96, 1 => 1), array(0 => 96, 1 => 3),
                                      array(0 => 93, 1 => 2), array(0 => 97, 1 => 1), array(0 => 97, 1 => 2),
                                      array(0 => 98, 1 => 3), array(0 => 98, 1 => 3), array(0 => 98, 1 => 5),
                                      array(0 => 98, 1 => 6), array(0 => 98, 1 => 2), array(0 => 89, 1 => 4),
                                      array(0 => 99, 1 => 4), array(0 => 99, 1 => 4), array(0 => 100, 1 => 3),
                                      array(0 => 100, 1 => 1), array(0 => 100, 1 => 0), array(0 => 77, 1 => 3),
                                      array(0 => 77, 1 => 2), array(0 => 101, 1 => 3), array(0 => 101, 1 => 2),
                                      array(0 => 82, 1 => 2), array(0 => 82, 1 => 0), array(0 => 102, 1 => 2),
                                      array(0 => 102, 1 => 2), array(0 => 92, 1 => 1), array(0 => 92, 1 => 2),
                                      array(0 => 92, 1 => 1), array(0 => 92, 1 => 2), array(0 => 92, 1 => 3),
                                      array(0 => 87, 1 => 1), array(0 => 87, 1 => 1), array(0 => 86, 1 => 1),
                                      array(0 => 88, 1 => 1), array(0 => 85, 1 => 3), array(0 => 103, 1 => 1),
                                      array(0 => 103, 1 => 3), array(0 => 103, 1 => 0), array(0 => 104, 1 => 3),
                                      array(0 => 104, 1 => 3), array(0 => 104, 1 => 1), array(0 => 91, 1 => 2),
                                      array(0 => 91, 1 => 3), array(0 => 105, 1 => 2), array(0 => 105, 1 => 1),
                                      array(0 => 106, 1 => 3), array(0 => 106, 1 => 3), array(0 => 106, 1 => 1),
                                      array(0 => 106, 1 => 3), array(0 => 106, 1 => 3), array(0 => 106, 1 => 1),
                                      array(0 => 106, 1 => 1),);

    public static $yyReduceMap = array(0 => 0, 1 => 1, 2 => 2, 4 => 4, 5 => 5, 6 => 6, 7 => 7, 8 => 8, 9 => 9, 17 => 9,
                                       18 => 9, 44 => 9, 67 => 9, 68 => 9, 76 => 9, 77 => 9, 81 => 9, 90 => 9, 95 => 9,
                                       96 => 9, 101 => 9, 105 => 9, 106 => 9, 110 => 9, 112 => 9, 117 => 9, 179 => 9,
                                       184 => 9, 10 => 10, 11 => 11, 12 => 12, 13 => 13, 16 => 13, 14 => 14, 75 => 14,
                                       15 => 15, 91 => 15, 93 => 15, 94 => 15, 124 => 15, 19 => 19, 20 => 20, 21 => 21,
                                       23 => 21, 25 => 21, 22 => 22, 24 => 22, 26 => 22, 27 => 27, 28 => 27, 29 => 29,
                                       30 => 30, 31 => 31, 32 => 32, 33 => 33, 34 => 34, 35 => 35, 36 => 36, 37 => 37,
                                       38 => 38, 39 => 39, 41 => 39, 40 => 40, 42 => 42, 43 => 43, 45 => 45, 46 => 46,
                                       47 => 47, 48 => 48, 50 => 48, 49 => 49, 51 => 49, 52 => 52, 53 => 53, 54 => 54,
                                       55 => 55, 56 => 56, 57 => 57, 58 => 58, 59 => 59, 60 => 60, 61 => 61, 70 => 61,
                                       159 => 61, 163 => 61, 167 => 61, 168 => 61, 62 => 62, 160 => 62, 166 => 62,
                                       63 => 63, 64 => 64, 65 => 64, 66 => 66, 144 => 66, 69 => 69, 71 => 71, 72 => 72,
                                       73 => 72, 74 => 74, 78 => 78, 79 => 79, 80 => 79, 82 => 82, 109 => 82, 83 => 83,
                                       84 => 84, 85 => 85, 86 => 86, 87 => 87, 88 => 88, 89 => 89, 92 => 92, 97 => 97,
                                       98 => 98, 99 => 99, 100 => 100, 102 => 102, 103 => 103, 104 => 103, 107 => 107,
                                       108 => 108, 111 => 111, 113 => 113, 114 => 114, 115 => 115, 116 => 116,
                                       118 => 118, 119 => 119, 120 => 120, 121 => 121, 122 => 122, 123 => 123,
                                       125 => 125, 181 => 125, 126 => 126, 127 => 127, 128 => 128, 129 => 129,
                                       130 => 130, 131 => 131, 139 => 131, 132 => 132, 133 => 133, 134 => 134,
                                       135 => 134, 137 => 134, 138 => 134, 136 => 136, 140 => 140, 141 => 141,
                                       142 => 142, 185 => 142, 143 => 143, 145 => 145, 146 => 146, 147 => 147,
                                       148 => 148, 149 => 149, 150 => 150, 151 => 151, 152 => 152, 153 => 153,
                                       154 => 154, 155 => 155, 156 => 156, 157 => 157, 158 => 158, 161 => 161,
                                       162 => 162, 164 => 164, 165 => 165, 169 => 169, 170 => 170, 171 => 171,
                                       172 => 172, 173 => 173, 174 => 174, 175 => 175, 176 => 176, 177 => 177,
                                       178 => 178, 180 => 180, 182 => 182, 183 => 183, 186 => 186, 187 => 187,
                                       188 => 188, 189 => 189, 190 => 189, 192 => 189, 191 => 191, 193 => 193,
                                       194 => 194, 195 => 195,);

    #line 218 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r0()
    {
        $this->root_buffer->prepend_array($this, $this->template_prefix);
        $this->root_buffer->append_array($this, $this->template_postfix);
        $this->_retvalue = $this->root_buffer->to_smarty_php($this);
    }

    #line 228 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r1()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor != null) {
            $this->current_buffer->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 235 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r2()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor != null) {
            // because of possible code injection
            $this->current_buffer->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 249 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r4()
    {
        if ($this->compiler->has_code) {
            $this->_retvalue = $this->mergePrefixCode($this->yystack[ $this->yyidx + 0 ]->minor);
        } else {
            $this->_retvalue = null;
        }
        $this->compiler->has_variable_string = false;
        $this->block_nesting_level = count($this->compiler->_tag_stack);
    }

    #line 260 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r5()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Text($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 264 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r6()
    {
        $code = $this->compiler->compileTag('private_php',
                                            array(array('code' => $this->yystack[ $this->yyidx + 0 ]->minor),
                                                  array('type' => $this->lex->phpType)), array());
        if ($this->compiler->has_code && !empty($code)) {
            $tmp = '';
            foreach ($this->compiler->prefix_code as $code) {
                $tmp .= $code;
            }
            $this->compiler->prefix_code = array();
            $this->_retvalue =
                new Smarty_Internal_ParseTree_Tag($this, $this->compiler->processNocacheCode($tmp . $code, true));
        } else {
            $this->_retvalue = null;
        }
    }

    #line 275 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r7()
    {
        $this->compiler->tag_nocache = true;
        $save = $this->template->compiled->has_nocache_code;
        $this->_retvalue = new Smarty_Internal_ParseTree_Tag($this,
                                                             $this->compiler->processNocacheCode("<?php echo '{$this->yystack[$this->yyidx + 0]->minor}';?>\n",
                                                                                                 true));
        $this->template->compiled->has_nocache_code = $save;
    }

    #line 282 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r8()
    {
        $this->_retvalue = $this->compiler->processText($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 286 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r9()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 290 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r10()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 295 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r11()
    {
        $this->strip = true;
    }

    #line 299 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r12()
    {
        $this->strip = false;
    }

    #line 304 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r13()
    {
        $this->_retvalue = '';
    }

    #line 308 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r14()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 312 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r15()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 328 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r19()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 334 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r20()
    {
        $var =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' $');
        if (preg_match('/^(.*)(\s+nocache)$/', $var, $match)) {
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array('nocache'),
                                                           array('value' => $this->compiler->compileVariable('\'' .
                                                                                                             $match[ 1 ] .
                                                                                                             '\'')));
        } else {
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                           array('value' => $this->compiler->compileVariable('\'' .
                                                                                                             $var .
                                                                                                             '\'')));
        }
    }

    #line 344 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r21()
    {
        $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                       array('value' => $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 348 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r22()
    {
        $this->_retvalue =
            $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                        array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor));
    }

    #line 371 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r27()
    {
        $this->_retvalue = $this->compiler->compileTag('assign', array(array('value' => $this->yystack[ $this->yyidx +
                                                                                                        0 ]->minor),
                                                                       array('var' => '\'' .
                                                                                      substr($this->yystack[ $this->yyidx +
                                                                                                             - 2 ]->minor,
                                                                                             1) . '\'')));
    }

    #line 379 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r29()
    {
        $this->_retvalue = $this->compiler->compileTag('assign',
                                                       array_merge(array(array('value' => $this->yystack[ $this->yyidx +
                                                                                                          - 1 ]->minor),
                                                                         array('var' => '\'' .
                                                                                        substr($this->yystack[ $this->yyidx +
                                                                                                               - 3 ]->minor,
                                                                                               1) . '\'')),
                                                                   $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 383 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r30()
    {
        $this->_retvalue = $this->compiler->compileTag('assign',
                                                       array_merge(array(array('value' => $this->yystack[ $this->yyidx +
                                                                                                          - 1 ]->minor),
                                                                         array('var' => $this->yystack[ $this->yyidx +
                                                                                                        - 3 ]->minor[ 'var' ])),
                                                                   $this->yystack[ $this->yyidx + 0 ]->minor),
                                                       array('smarty_internal_index' => $this->yystack[ $this->yyidx +
                                                                                                        - 3 ]->minor[ 'smarty_internal_index' ]));
    }

    #line 388 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r31()
    {
        $tag =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length));
        if ($tag == 'strip') {
            $this->strip = true;
            $this->_retvalue = null;;
        } else {
            if (defined($tag)) {
                if ($this->security) {
                    $this->security->isTrustedConstant($tag, $this->compiler);
                }
                $this->_retvalue =
                    $this->compiler->compileTag('private_print_expression', array(), array('value' => $tag));
            } else {
                if (preg_match('/^(.*)(\s+nocache)$/', $tag, $match)) {
                    $this->_retvalue = $this->compiler->compileTag($match[ 1 ], array("'nocache'"));
                } else {
                    $this->_retvalue = $this->compiler->compileTag($tag, array());
                }
            }
        }
    }

    #line 410 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r32()
    {
        if (defined($this->yystack[ $this->yyidx + - 1 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + - 1 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                            array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor));
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 1 ]->minor,
                                                           $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 420 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r33()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                           array('value' => $this->yystack[ $this->yyidx + 0 ]->minor));
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + 0 ]->minor, array());
        }
    }

    #line 433 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r34()
    {
        if (defined($this->yystack[ $this->yyidx + - 2 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + - 2 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                            array('value' => $this->yystack[ $this->yyidx + - 2 ]->minor,
                                                  'modifierlist' => $this->yystack[ $this->yyidx + - 1 ]->minor));
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 2 ]->minor,
                                                           $this->yystack[ $this->yyidx + 0 ]->minor,
                                                           array('modifierlist' => $this->yystack[ $this->yyidx +
                                                                                                   - 1 ]->minor));
        }
    }

    #line 445 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r35()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 3 ]->minor,
                                                       $this->yystack[ $this->yyidx + 0 ]->minor,
                                                       array('object_method' => $this->yystack[ $this->yyidx +
                                                                                                - 1 ]->minor));
    }

    #line 450 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r36()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 4 ]->minor,
                                                       $this->yystack[ $this->yyidx + 0 ]->minor,
                                                       array('modifierlist' => $this->yystack[ $this->yyidx +
                                                                                               - 1 ]->minor,
                                                             'object_method' => $this->yystack[ $this->yyidx +
                                                                                                - 2 ]->minor));
    }

    #line 455 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r37()
    {
        $this->_retvalue = $this->compiler->compileTag('make_nocache', array(array('var' => '\'' .
                                                                                            substr($this->yystack[ $this->yyidx +
                                                                                                                   0 ]->minor,
                                                                                                   1) . '\'')));
    }

    #line 460 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r38()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 1 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag, array(),
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                                                               0 ]->minor));
    }

    #line 465 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r39()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 2 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag,
                                                       $this->yystack[ $this->yyidx + 0 ]->minor,
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                                                               - 1 ]->minor));
    }

    #line 470 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r40()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 1 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag, array(),
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                                                               0 ]->minor));
    }

    #line 481 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r42()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                                                                 - 6 ]->minor),
                                                                                array('ifexp' => $this->yystack[ $this->yyidx +
                                                                                                                 - 4 ]->minor),
                                                                                array('var' => $this->yystack[ $this->yyidx +
                                                                                                               - 2 ]->minor),
                                                                                array('step' => $this->yystack[ $this->yyidx +
                                                                                                                - 1 ]->minor))),
                                                       1);
    }

    #line 485 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r43()
    {
        $this->_retvalue = '=' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 493 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r45()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                                                                 - 3 ]->minor),
                                                                                array('to' => $this->yystack[ $this->yyidx +
                                                                                                              - 1 ]->minor))),
                                                       0);
    }

    #line 497 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r46()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                                                                 - 5 ]->minor),
                                                                                array('to' => $this->yystack[ $this->yyidx +
                                                                                                              - 3 ]->minor),
                                                                                array('step' => $this->yystack[ $this->yyidx +
                                                                                                                - 1 ]->minor))),
                                                       0);
    }

    #line 502 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r47()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 507 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r48()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                              array(array('from' => $this->yystack[ $this->yyidx +
                                                                                                                    - 3 ]->minor),
                                                                                    array('item' => $this->yystack[ $this->yyidx +
                                                                                                                    - 1 ]->minor))));
    }

    #line 511 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r49()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                              array(array('from' => $this->yystack[ $this->yyidx +
                                                                                                                    - 5 ]->minor),
                                                                                    array('item' => $this->yystack[ $this->yyidx +
                                                                                                                    - 1 ]->minor),
                                                                                    array('key' => $this->yystack[ $this->yyidx +
                                                                                                                   - 3 ]->minor))));
    }

    #line 524 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r52()
    {
        $this->_retvalue = $this->compiler->compileTag('setfilter', array(),
                                                       array('modifier_list' => array(array_merge(array($this->yystack[ $this->yyidx +
                                                                                                                        - 1 ]->minor),
                                                                                                  $this->yystack[ $this->yyidx +
                                                                                                                  0 ]->minor))));
    }

    #line 528 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r53()
    {
        $this->_retvalue = $this->compiler->compileTag('setfilter', array(),
                                                       array('modifier_list' => array_merge(array(array_merge(array($this->yystack[ $this->yyidx +
                                                                                                                                    - 2 ]->minor),
                                                                                                              $this->yystack[ $this->yyidx +
                                                                                                                              - 1 ]->minor)),
                                                                                            $this->yystack[ $this->yyidx +
                                                                                                            0 ]->minor)));
    }

    #line 533 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r54()
    {
        $j = strrpos($this->yystack[ $this->yyidx + 0 ]->minor, '.');
        if ($this->yystack[ $this->yyidx + 0 ]->minor[ $j + 1 ] == 'c') {
            // {$smarty.block.child}
            $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);
        } else {
            // {$smarty.block.parent}
            $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileParentBlock($this->compiler);
        }
    }

    #line 546 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r55()
    {
        $tag =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' /');
        if ($tag == 'strip') {
            $this->strip = false;
            $this->_retvalue = null;
        } else {
            $this->_retvalue = $this->compiler->compileTag($tag . 'close', array());
        }
    }

    #line 555 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r56()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + 0 ]->minor . 'close', array());
    }

    #line 559 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r57()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 1 ]->minor . 'close', array(),
                                                       array('modifier_list' => $this->yystack[ $this->yyidx +
                                                                                                0 ]->minor));
    }

    #line 564 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r58()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 2 ]->minor . 'close', array(),
                                                       array('object_method' => $this->yystack[ $this->yyidx +
                                                                                                0 ]->minor));
    }

    #line 568 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r59()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 3 ]->minor . 'close', array(),
                                                       array('object_method' => $this->yystack[ $this->yyidx +
                                                                                                - 1 ]->minor,
                                                             'modifier_list' => $this->yystack[ $this->yyidx +
                                                                                                0 ]->minor));
    }

    #line 576 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r60()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
        $this->_retvalue[] = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 582 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r61()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 587 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r62()
    {
        $this->_retvalue = array();
    }

    #line 592 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r63()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                array($this->yystack[ $this->yyidx + - 2 ]->minor => $this->yystack[ $this->yyidx + 0 ]->minor);
        } else {
            $this->_retvalue =
                array($this->yystack[ $this->yyidx + - 2 ]->minor => '\'' . $this->yystack[ $this->yyidx + 0 ]->minor .
                                                                     '\'');
        }
    }

    #line 603 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r64()
    {
        $this->_retvalue =
            array(trim($this->yystack[ $this->yyidx + - 1 ]->minor, " =\n\r\t") => $this->yystack[ $this->yyidx +
                                                                                                   0 ]->minor);
    }

    #line 611 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r66()
    {
        $this->_retvalue = '\'' . $this->yystack[ $this->yyidx + 0 ]->minor . '\'';
    }

    #line 623 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r69()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 2 ]->minor => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 636 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r71()
    {
        $this->yystack[ $this->yyidx + - 2 ]->minor[] = $this->yystack[ $this->yyidx + 0 ]->minor;
        $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor;
    }

    #line 641 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r72()
    {
        $this->_retvalue = array('var' => '\'' . substr($this->yystack[ $this->yyidx + - 2 ]->minor, 1) . '\'',
                                 'value' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 648 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r74()
    {
        $this->_retvalue = array('var' => $this->yystack[ $this->yyidx + - 2 ]->minor,
                                 'value' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 672 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r78()
    {
        $this->_retvalue =
            '$_smarty_tpl->getStreamVariable(\'' . substr($this->yystack[ $this->yyidx + - 2 ]->minor, 1) . '://' .
            $this->yystack[ $this->yyidx + 0 ]->minor . '\')';
    }

    #line 677 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r79()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . trim($this->yystack[ $this->yyidx + - 1 ]->minor) .
            $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 691 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r82()
    {
        $this->_retvalue = $this->compiler->compileTag('private_modifier', array(),
                                                       array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor,
                                                             'modifierlist' => $this->yystack[ $this->yyidx +
                                                                                               0 ]->minor));
    }

    #line 697 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r83()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 1 ]->minor[ 'pre' ] . $this->yystack[ $this->yyidx + - 2 ]->minor .
            $this->yystack[ $this->yyidx + - 1 ]->minor[ 'op' ] . $this->yystack[ $this->yyidx + 0 ]->minor . ')';
    }

    #line 701 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r84()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor .
                           $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 705 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r85()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + 0 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 709 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r86()
    {
        $this->_retvalue = 'in_array(' . $this->yystack[ $this->yyidx + - 2 ]->minor . ',' .
                           $this->yystack[ $this->yyidx + 0 ]->minor . ')';
    }

    #line 713 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r87()
    {
        $this->_retvalue = 'in_array(' . $this->yystack[ $this->yyidx + - 2 ]->minor . ',(array)' .
                           $this->yystack[ $this->yyidx + 0 ]->minor . ')';
    }

    #line 721 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r88()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 5 ]->minor . ' ? ' . $this->compiler->compileVariable('\'' .
                                                                                                                  substr($this->yystack[ $this->yyidx +
                                                                                                                                         - 2 ]->minor,
                                                                                                                         1) .
                                                                                                                  '\'') .
                           ' : ' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 725 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r89()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 5 ]->minor . ' ? ' . $this->yystack[ $this->yyidx + - 2 ]->minor . ' : ' .
            $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 740 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r92()
    {
        $this->_retvalue = '!' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 761 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r97()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 765 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r98()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . '.';
    }

    #line 769 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r99()
    {
        $this->_retvalue = '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 774 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r100()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
        } else {
            $this->_retvalue = '\'' . $this->yystack[ $this->yyidx + 0 ]->minor . '\'';
        }
    }

    #line 791 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r102()
    {
        $this->_retvalue = "(" . $this->yystack[ $this->yyidx + - 1 ]->minor . ")";
    }

    #line 795 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r103()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor .
                           $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 813 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r107()
    {
        $prefixVar = $this->compiler->getNewPrefixVariable();
        if ($this->yystack[ $this->yyidx + - 2 ]->minor[ 'var' ] == '\'smarty\'') {
            $this->compiler->appendPrefixCode("<?php $prefixVar" . ' = ' .
                                              $this->compiler->compileTag('private_special_variable', array(),
                                                                          $this->yystack[ $this->yyidx +
                                                                                          - 2 ]->minor[ 'smarty_internal_index' ]) .
                                              ';?>');
        } else {
            $this->compiler->appendPrefixCode("<?php $prefixVar" . ' = ' .
                                              $this->compiler->compileVariable($this->yystack[ $this->yyidx +
                                                                                               - 2 ]->minor[ 'var' ]) .
                                              $this->yystack[ $this->yyidx + - 2 ]->minor[ 'smarty_internal_index' ] .
                                              ';?>');
        }
        $this->_retvalue = $prefixVar . '::' . $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] .
                           $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
    }

    #line 824 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r108()
    {
        $prefixVar = $this->compiler->getNewPrefixVariable();
        $tmp = $this->compiler->appendCode('<?php ob_start();?>', $this->yystack[ $this->yyidx + 0 ]->minor);
        $this->compiler->appendPrefixCode($this->compiler->appendCode($tmp, "<?php $prefixVar" . '=ob_get_clean();?>'));
        $this->_retvalue = $prefixVar;
    }

    #line 841 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r111()
    {
        if (!in_array(strtolower($this->yystack[ $this->yyidx + - 2 ]->minor), array('self', 'parent')) &&
            (!$this->security ||
             $this->security->isTrustedStaticClassAccess($this->yystack[ $this->yyidx + - 2 ]->minor,
                                                         $this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler))
        ) {
            if (isset($this->smarty->registered_classes[ $this->yystack[ $this->yyidx + - 2 ]->minor ])) {
                $this->_retvalue =
                    $this->smarty->registered_classes[ $this->yystack[ $this->yyidx + - 2 ]->minor ] . '::' .
                    $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] . $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
            } else {
                $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor . '::' .
                                   $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] .
                                   $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
            }
        } else {
            $this->compiler->trigger_template_error("static class '" . $this->yystack[ $this->yyidx + - 2 ]->minor .
                                                    "' is undefined or not allowed by security setting");
        }
    }

    #line 860 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r113()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 871 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r114()
    {
        $this->_retvalue =
            $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'');
    }

    #line 874 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r115()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ] == '\'smarty\'') {
            $smarty_var = $this->compiler->compileTag('private_special_variable', array(),
                                                      $this->yystack[ $this->yyidx +
                                                                      0 ]->minor[ 'smarty_internal_index' ]);
            $this->_retvalue = $smarty_var;
        } else {
            // used for array reset,next,prev,end,current
            $this->last_variable = $this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ];
            $this->last_index = $this->yystack[ $this->yyidx + 0 ]->minor[ 'smarty_internal_index' ];
            $this->_retvalue = $this->compiler->compileVariable($this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ]) .
                               $this->yystack[ $this->yyidx + 0 ]->minor[ 'smarty_internal_index' ];
        }
    }

    #line 887 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r116()
    {
        $this->_retvalue = '$_smarty_tpl->tpl_vars[' . $this->yystack[ $this->yyidx + - 2 ]->minor . ']->' .
                           $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 897 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r118()
    {
        $this->_retvalue =
            $this->compiler->compileConfigVariable("'" . $this->yystack[ $this->yyidx + - 1 ]->minor . "'");
    }

    #line 901 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r119()
    {
        $this->_retvalue = '(is_array($tmp = ' .
                           $this->compiler->compileConfigVariable("'" . $this->yystack[ $this->yyidx + - 2 ]->minor .
                                                                  "'") . ') ? $tmp' .
                           $this->yystack[ $this->yyidx + 0 ]->minor . ' :null)';
    }

    #line 905 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r120()
    {
        $this->_retvalue = $this->compiler->compileConfigVariable($this->yystack[ $this->yyidx + - 1 ]->minor);
    }

    #line 909 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r121()
    {
        $this->_retvalue =
            '(is_array($tmp = ' . $this->compiler->compileConfigVariable($this->yystack[ $this->yyidx + - 2 ]->minor) .
            ') ? $tmp' . $this->yystack[ $this->yyidx + 0 ]->minor . ' : null)';
    }

    #line 913 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r122()
    {
        $this->_retvalue = array('var' => '\'' . substr($this->yystack[ $this->yyidx + - 1 ]->minor, 1) . '\'',
                                 'smarty_internal_index' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 916 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r123()
    {
        $this->_retvalue = array('var' => $this->yystack[ $this->yyidx + - 1 ]->minor,
                                 'smarty_internal_index' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 929 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r125()
    {
        return;
    }

    #line 935 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r126()
    {
        $this->_retvalue =
            '[' . $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'') .
            ']';
    }

    #line 938 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r127()
    {
        $this->_retvalue = '[' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + 0 ]->minor) . ']';
    }

    #line 942 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r128()
    {
        $this->_retvalue = '[' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 2 ]->minor) . '->' .
                           $this->yystack[ $this->yyidx + 0 ]->minor . ']';
    }

    #line 946 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r129()
    {
        $this->_retvalue = "['" . $this->yystack[ $this->yyidx + 0 ]->minor . "']";
    }

    #line 950 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r130()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + 0 ]->minor . ']';
    }

    #line 955 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r131()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + - 1 ]->minor . ']';
    }

    #line 960 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r132()
    {
        $this->_retvalue = '[' . $this->compiler->compileTag('private_special_variable', array(), '[\'section\'][\'' .
                                                                                                  $this->yystack[ $this->yyidx +
                                                                                                                  - 1 ]->minor .
                                                                                                  '\'][\'index\']') .
                           ']';
    }

    #line 964 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r133()
    {
        $this->_retvalue = '[' . $this->compiler->compileTag('private_special_variable', array(), '[\'section\'][\'' .
                                                                                                  $this->yystack[ $this->yyidx +
                                                                                                                  - 3 ]->minor .
                                                                                                  '\'][\'' .
                                                                                                  $this->yystack[ $this->yyidx +
                                                                                                                  - 1 ]->minor .
                                                                                                  '\']') . ']';
    }

    #line 967 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r134()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + - 1 ]->minor . ']';
    }

    #line 973 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r136()
    {
        $this->_retvalue = '[' . $this->compiler->compileVariable('\'' .
                                                                  substr($this->yystack[ $this->yyidx + - 1 ]->minor,
                                                                         1) . '\'') . ']';;
    }

    #line 989 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r140()
    {
        $this->_retvalue = '[]';
    }

    #line 999 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r141()
    {
        $this->_retvalue = '\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'';
    }

    #line 1003 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r142()
    {
        $this->_retvalue = "''";
    }

    #line 1008 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r143()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 1 ]->minor . '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1016 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r145()
    {
        $var =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' $');
        $this->_retvalue = $this->compiler->compileVariable('\'' . $var . '\'');
    }

    #line 1022 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r146()
    {
        $this->_retvalue = '(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 1029 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r147()
    {
        if ($this->yystack[ $this->yyidx + - 1 ]->minor[ 'var' ] == '\'smarty\'') {
            $this->_retvalue = $this->compiler->compileTag('private_special_variable', array(),
                                                           $this->yystack[ $this->yyidx +
                                                                           - 1 ]->minor[ 'smarty_internal_index' ]) .
                               $this->yystack[ $this->yyidx + 0 ]->minor;
        } else {
            $this->_retvalue = $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 1 ]->minor[ 'var' ]) .
                               $this->yystack[ $this->yyidx + - 1 ]->minor[ 'smarty_internal_index' ] .
                               $this->yystack[ $this->yyidx + 0 ]->minor;
        }
    }

    #line 1038 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r148()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1043 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r149()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1048 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r150()
    {
        if ($this->security && substr($this->yystack[ $this->yyidx + - 1 ]->minor, 0, 1) == '_') {
            $this->compiler->trigger_template_error(self::Err1);
        }
        $this->_retvalue =
            '->' . $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1055 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r151()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue = '->{' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 1 ]->minor) .
                           $this->yystack[ $this->yyidx + 0 ]->minor . '}';
    }

    #line 1062 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r152()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue =
            '->{' . $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor . '}';
    }

    #line 1069 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r153()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue = '->{\'' . $this->yystack[ $this->yyidx + - 4 ]->minor . '\'.' .
                           $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor .
                           '}';
    }

    #line 1077 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r154()
    {
        $this->_retvalue = '->' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1085 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r155()
    {
        if (!$this->security ||
            $this->security->isTrustedPhpFunction($this->yystack[ $this->yyidx + - 3 ]->minor, $this->compiler)
        ) {
            if (strcasecmp($this->yystack[ $this->yyidx + - 3 ]->minor, 'isset') === 0 ||
                strcasecmp($this->yystack[ $this->yyidx + - 3 ]->minor, 'empty') === 0 ||
                strcasecmp($this->yystack[ $this->yyidx + - 3 ]->minor, 'array') === 0 ||
                is_callable($this->yystack[ $this->yyidx + - 3 ]->minor)
            ) {
                $func_name = strtolower($this->yystack[ $this->yyidx + - 3 ]->minor);
                if ($func_name == 'isset') {
                    if (count($this->yystack[ $this->yyidx + - 1 ]->minor) == 0) {
                        $this->compiler->trigger_template_error('Illegal number of paramer in "isset()"');
                    }
                    $par = implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor);
                    if (strncasecmp($par, '$_smarty_tpl->smarty->ext->_config->_getConfigVariable',
                                    strlen('$_smarty_tpl->smarty->ext->_config->_getConfigVariable')) === 0
                    ) {
                        $prefixVar = $this->compiler->getNewPrefixVariable();
                        $this->compiler->appendPrefixCode("<?php $prefixVar" . '=' .
                                                          str_replace(')', ', false)', $par) . ';?>');
                        $isset_par = $prefixVar;
                    } else {
                        $isset_par = str_replace("')->value", "',null,true,false)->value", $par);
                    }
                    $this->_retvalue = $this->yystack[ $this->yyidx + - 3 ]->minor . "(" . $isset_par . ")";
                } elseif (in_array($func_name, array('empty', 'reset', 'current', 'end', 'prev', 'next'))) {
                    if (count($this->yystack[ $this->yyidx + - 1 ]->minor) != 1) {
                        $this->compiler->trigger_template_error('Illegal number of paramer in "empty()"');
                    }
                    if ($func_name == 'empty') {
                        $this->_retvalue = $func_name . '(' . str_replace("')->value", "',null,true,false)->value",
                                                                          $this->yystack[ $this->yyidx +
                                                                                          - 1 ]->minor[ 0 ]) . ')';
                    } else {
                        $this->_retvalue = $func_name . '(' . $this->yystack[ $this->yyidx + - 1 ]->minor[ 0 ] . ')';
                    }
                } else {
                    $this->_retvalue = $this->yystack[ $this->yyidx + - 3 ]->minor . "(" .
                                       implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor) . ")";
                }
            } else {
                $this->compiler->trigger_template_error("unknown function \"" .
                                                        $this->yystack[ $this->yyidx + - 3 ]->minor . "\"");
            }
        }
    }

    #line 1124 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r156()
    {
        if ($this->security && substr($this->yystack[ $this->yyidx + - 3 ]->minor, 0, 1) == '_') {
            $this->compiler->trigger_template_error(self::Err1);
        }
        $this->_retvalue = $this->yystack[ $this->yyidx + - 3 ]->minor . "(" .
                           implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor) . ")";
    }

    #line 1131 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r157()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $prefixVar = $this->compiler->getNewPrefixVariable();
        $this->compiler->appendPrefixCode("<?php $prefixVar" . '=' . $this->compiler->compileVariable('\'' .
                                                                                                      substr($this->yystack[ $this->yyidx +
                                                                                                                             - 3 ]->minor,
                                                                                                             1) .
                                                                                                      '\'') . ';?>');
        $this->_retvalue = $prefixVar . '(' . implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor) . ')';
    }

    #line 1142 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r158()
    {
        $this->_retvalue =
            array_merge($this->yystack[ $this->yyidx + - 2 ]->minor, array($this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 1159 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r161()
    {
        $this->_retvalue = array_merge($this->yystack[ $this->yyidx + - 2 ]->minor,
                                       array(array_merge($this->yystack[ $this->yyidx + - 1 ]->minor,
                                                         $this->yystack[ $this->yyidx + 0 ]->minor)));
    }

    #line 1163 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r162()
    {
        $this->_retvalue =
            array(array_merge($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 1171 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r164()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1179 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r165()
    {
        $this->_retvalue =
            array_merge($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1198 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r169()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor, '', 'method');
    }

    #line 1203 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r170()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor, 'method');
    }

    #line 1208 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r171()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor, '');
    }

    #line 1213 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r172()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor, 'property');
    }

    #line 1218 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r173()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + - 2 ]->minor,
                                 $this->yystack[ $this->yyidx + - 1 ]->minor .
                                 $this->yystack[ $this->yyidx + 0 ]->minor, 'property');
    }

    #line 1224 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r174()
    {
        $this->_retvalue = ' ' . trim($this->yystack[ $this->yyidx + 0 ]->minor) . ' ';
    }

    #line 1228 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r175()
    {
        static $lops =
            array('eq' => ' == ', 'ne' => ' != ', 'neq' => ' != ', 'gt' => ' > ', 'ge' => ' >= ', 'gte' => ' >= ',
                  'lt' => ' < ', 'le' => ' <= ', 'lte' => ' <= ', 'mod' => ' % ', 'and' => ' && ', 'or' => ' || ',
                  'xor' => ' xor ',);
        $op = strtolower(preg_replace('/\s*/', '', $this->yystack[ $this->yyidx + 0 ]->minor));
        $this->_retvalue = $lops[ $op ];
    }

    #line 1247 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r176()
    {
        static $tlops =
            array('isdivby' => array('op' => ' % ', 'pre' => '!('), 'isnotdivby' => array('op' => ' % ', 'pre' => '('),
                  'isevenby' => array('op' => ' / ', 'pre' => '!(1 & '),
                  'isnotevenby' => array('op' => ' / ', 'pre' => '(1 & '),
                  'isoddby' => array('op' => ' / ', 'pre' => '(1 & '),
                  'isnotoddby' => array('op' => ' / ', 'pre' => '!(1 & '),);
        $op = strtolower(preg_replace('/\s*/', '', $this->yystack[ $this->yyidx + 0 ]->minor));
        $this->_retvalue = $tlops[ $op ];
    }

    #line 1260 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r177()
    {
        static $scond =
            array('iseven' => '!(1 & ', 'isnoteven' => '(1 & ', 'isodd' => '(1 & ', 'isnotodd' => '!(1 & ',);
        $op = strtolower(str_replace(' ', '', $this->yystack[ $this->yyidx + 0 ]->minor));
        $this->_retvalue = $scond[ $op ];
    }

    #line 1274 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r178()
    {
        $this->_retvalue = 'array(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 1282 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r180()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . ',' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1290 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r182()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . '=>' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1294 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r183()
    {
        $this->_retvalue =
            '\'' . $this->yystack[ $this->yyidx + - 2 ]->minor . '\'=>' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1310 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r186()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor->to_smarty_php($this);
    }

    #line 1315 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r187()
    {
        $this->yystack[ $this->yyidx + - 1 ]->minor->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 1320 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r188()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Dq($this, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1324 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r189()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Code('(string)' . $this->yystack[ $this->yyidx + - 1 ]->minor);
    }

    #line 1332 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r191()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Code('(string)$_smarty_tpl->tpl_vars[\'' .
                                                              substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) .
                                                              '\']->value');
    }

    #line 1340 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r193()
    {
        $this->_retvalue =
            new Smarty_Internal_ParseTree_Code('(string)(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')');
    }

    #line 1344 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r194()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Tag($this, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1348 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r195()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_DqContent($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    private $_retvalue;

    public function yy_reduce($yyruleno)
    {
        if ($this->yyTraceFILE && $yyruleno >= 0 && $yyruleno < count(self::$yyRuleName)) {
            fprintf($this->yyTraceFILE, "%sReduce (%d) [%s].\n", $this->yyTracePrompt, $yyruleno,
                    self::$yyRuleName[ $yyruleno ]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (isset(self::$yyReduceMap[ $yyruleno ])) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[ $yyruleno ]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[ $yyruleno ][ 0 ];
        $yysize = self::$yyRuleInfo[ $yyruleno ][ 1 ];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i --) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!$this->yyTraceFILE && $yysize) {
                $this->yyidx ++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[ $this->yyidx ] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    public function yy_parse_failed()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sFail!\n", $this->yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    public function yy_syntax_error($yymajor, $TOKEN)
    {
        #line 200 "../smarty/lexer/smarty_internal_templateparser.y"

        $this->internalError = true;
        $this->yymajor = $yymajor;
        $this->compiler->trigger_template_error();
    }

    public function yy_accept()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sAccept!\n", $this->yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        #line 193 "../smarty/lexer/smarty_internal_templateparser.y"

        $this->successful = !$this->internalError;
        $this->internalError = false;
        $this->retvalue = $this->_retvalue;
    }

    public function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = - 1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            $this->yystack[] = $x;
        }
        $yyendofinput = ($yymajor == 0);

        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sInput %s\n", $this->yyTracePrompt, $this->yyTokenName[ $yymajor ]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL && !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt --;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if ($this->yyTraceFILE) {
                    fprintf($this->yyTraceFILE, "%sSyntax Error!\n", $this->yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[ $this->yyidx ]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit) {
                        if ($this->yyTraceFILE) {
                            fprintf($this->yyTraceFILE, "%sDiscard input token %s\n", $this->yyTracePrompt,
                                    $this->yyTokenName[ $yymajor ]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 && $yymx != self::YYERRORSYMBOL &&
                               ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE) {
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor == 0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        }
        while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}

